/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.util.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.mockito.internal.util.reflection.AccessibilityChanger;
import org.mockito.internal.util.reflection.FieldCopier;

public class LenientCopyTool {
    FieldCopier fieldCopier = new FieldCopier();

    public <T> void copyToMock(T from, T mock) {
        this.copy(from, mock, from.getClass(), mock.getClass().getSuperclass());
    }

    public <T> void copyToRealObject(T from, T to) {
        this.copy(from, to, from.getClass(), to.getClass());
    }

    private <T> void copy(T from, T to, Class fromClazz, Class toClass) {
        while (fromClazz != Object.class) {
            this.copyValues(from, to, fromClazz);
            fromClazz = fromClazz.getSuperclass();
        }
    }

    private <T> void copyValues(T from, T mock, Class classFrom) {
        Field[] fields = classFrom.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            block7: {
                Field field = fields[i];
                if (!Modifier.isStatic(field.getModifiers())) {
                    AccessibilityChanger accessibilityChanger = new AccessibilityChanger();
                    try {
                        try {
                            accessibilityChanger.enableAccess(field);
                            this.fieldCopier.copyValue(from, mock, field);
                        }
                        catch (Throwable throwable) {
                            accessibilityChanger.safelyDisableAccess(field);
                            break block7;
                        }
                    }
                    catch (Throwable throwable) {
                        accessibilityChanger.safelyDisableAccess(field);
                        throw throwable;
                    }
                    accessibilityChanger.safelyDisableAccess(field);
                }
            }
            ++i;
        }
    }
}

