/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.asm.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.mockito.asm.Label;
import org.mockito.asm.MethodVisitor;
import org.mockito.asm.tree.AbstractInsnNode;
import org.mockito.asm.tree.LabelNode;

public class LookupSwitchInsnNode
extends AbstractInsnNode {
    public LabelNode dflt;
    public List keys;
    public List labels;

    public LookupSwitchInsnNode(LabelNode dflt, int[] keys, LabelNode[] labels) {
        super(171);
        this.dflt = dflt;
        this.keys = new ArrayList(keys == null ? 0 : keys.length);
        this.labels = new ArrayList(labels == null ? 0 : labels.length);
        if (keys != null) {
            int i = 0;
            while (i < keys.length) {
                this.keys.add(new Integer(keys[i]));
                ++i;
            }
        }
        if (labels != null) {
            this.labels.addAll(Arrays.asList(labels));
        }
    }

    @Override
    public int getType() {
        return 11;
    }

    @Override
    public void accept(MethodVisitor mv) {
        int[] keys = new int[this.keys.size()];
        int i = 0;
        while (i < keys.length) {
            keys[i] = (Integer)this.keys.get(i);
            ++i;
        }
        Label[] labels = new Label[this.labels.size()];
        int i2 = 0;
        while (i2 < labels.length) {
            labels[i2] = ((LabelNode)this.labels.get(i2)).getLabel();
            ++i2;
        }
        mv.visitLookupSwitchInsn(this.dflt.getLabel(), keys, labels);
    }

    @Override
    public AbstractInsnNode clone(Map labels) {
        LookupSwitchInsnNode clone = new LookupSwitchInsnNode(LookupSwitchInsnNode.clone(this.dflt, labels), null, LookupSwitchInsnNode.clone(this.labels, labels));
        clone.keys.addAll(this.keys);
        return clone;
    }
}

