/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.SingleItemFilter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.GeneralNodePattern;
import net.sf.saxon.pattern.ItemTypePattern;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.SimplePositionalPattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.Int64Value;

public final class FirstItemExpression
extends SingleItemFilter {
    private FirstItemExpression(Expression base) {
        this.operand = base;
        this.adoptChildExpression(base);
    }

    public static Expression makeFirstItemExpression(Expression base) {
        if (base instanceof FirstItemExpression) {
            return base;
        }
        return new FirstItemExpression(base);
    }

    public Expression copy() {
        return new FirstItemExpression(this.getBaseExpression().copy());
    }

    public Pattern toPattern(Configuration config, boolean is30) throws XPathException {
        Pattern basePattern = this.operand.toPattern(config, is30);
        ItemType type = basePattern.getItemType();
        if (type instanceof NodeTest) {
            if (basePattern instanceof ItemTypePattern) {
                return new SimplePositionalPattern((NodeTest)type, Literal.makeLiteral(Int64Value.PLUS_ONE), 50);
            }
            return new GeneralNodePattern(this, (NodeTest)type);
        }
        return basePattern;
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        SequenceIterator<? extends Item> iter = this.operand.iterate(context);
        Item result = iter.next();
        iter.close();
        return result;
    }

    public String getExpressionName() {
        return "firstItem";
    }
}

