/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.dom.DOMNodeList;
import net.sf.saxon.dom.NodeOverNodeInfo;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.expr.JPConverter;
import net.sf.saxon.expr.PJConverter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.ExternalObjectModel;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.om.VirtualNode;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.Value;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMEnvelope
implements ExternalObjectModel,
Serializable {
    private static DOMEnvelope THE_INSTANCE = new DOMEnvelope();

    public static DOMEnvelope getInstance() {
        return THE_INSTANCE;
    }

    @Override
    public String getIdentifyingURI() {
        return "http://java.sun.com/jaxp/xpath/dom";
    }

    @Override
    public PJConverter getPJConverter(Class targetClass) {
        if (NodeOverNodeInfo.class.isAssignableFrom(targetClass)) {
            return new PJConverter(){

                @Override
                public Object convert(ValueRepresentation value, Class targetClass, XPathContext context) throws XPathException {
                    return DOMEnvelope.this.convertXPathValueToObject(value, targetClass);
                }
            };
        }
        if (NodeList.class.isAssignableFrom(targetClass)) {
            return new PJConverter(){

                @Override
                public Object convert(ValueRepresentation value, Class targetClass, XPathContext context) throws XPathException {
                    return DOMEnvelope.this.convertXPathValueToObject(value, targetClass);
                }
            };
        }
        return null;
    }

    @Override
    public JPConverter getJPConverter(Class sourceClass) {
        if (NodeOverNodeInfo.class.isAssignableFrom(sourceClass)) {
            return new JPConverter(){

                @Override
                public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
                    return DOMEnvelope.this.convertObjectToXPathValue(object);
                }

                @Override
                public ItemType getItemType() {
                    return AnyNodeTest.getInstance();
                }
            };
        }
        return null;
    }

    @Override
    public PJConverter getNodeListCreator(Object node) {
        return null;
    }

    public boolean isRecognizedNode(Object object) {
        return object instanceof NodeOverNodeInfo;
    }

    public boolean isRecognizedNodeClass(Class nodeClass) {
        return NodeOverNodeInfo.class.isAssignableFrom(nodeClass);
    }

    @Override
    public Receiver getDocumentBuilder(Result result) throws XPathException {
        return null;
    }

    @Override
    public boolean sendSource(Source source, Receiver receiver, PipelineConfiguration pipe) throws XPathException {
        Node startNode;
        if (source instanceof DOMSource && (startNode = ((DOMSource)source).getNode()) instanceof NodeOverNodeInfo) {
            NodeInfo base = ((NodeOverNodeInfo)startNode).getUnderlyingNodeInfo();
            Sender driver = new Sender(pipe);
            driver.send(base, receiver, null);
            return true;
        }
        return false;
    }

    @Override
    public NodeInfo unravel(Source source, Configuration config) {
        Node dsnode;
        if (source instanceof DOMSource && (dsnode = ((DOMSource)source).getNode()) instanceof NodeOverNodeInfo) {
            return ((NodeOverNodeInfo)dsnode).getUnderlyingNodeInfo();
        }
        return null;
    }

    private ValueRepresentation convertObjectToXPathValue(Object object) throws XPathException {
        if (object instanceof NodeList) {
            NodeList list = (NodeList)object;
            int len = list.getLength();
            if (len == 0) {
                return null;
            }
            Item[] nodes = new NodeInfo[len];
            int i = 0;
            while (i < len) {
                if (!(list.item(i) instanceof NodeOverNodeInfo)) {
                    return null;
                }
                nodes[i] = ((NodeOverNodeInfo)list.item(i)).getUnderlyingNodeInfo();
                ++i;
            }
            return new SequenceExtent(nodes);
        }
        if (object instanceof NodeOverNodeInfo) {
            return ((NodeOverNodeInfo)object).getUnderlyingNodeInfo();
        }
        return null;
    }

    private Object convertXPathValueToObject(ValueRepresentation value, Object targetClass) throws XPathException {
        Item item;
        boolean allowDOM;
        Class target = (Class)targetClass;
        boolean requireDOM = Node.class.isAssignableFrom(target) || target == NodeList.class || target.isArray() && Node.class.isAssignableFrom(target.getComponentType());
        boolean bl = allowDOM = target == Object.class || target.isAssignableFrom(ArrayList.class) || target.isAssignableFrom(HashSet.class) || target.isArray() && target.getComponentType() == Object.class;
        if (!requireDOM && !allowDOM) {
            return null;
        }
        ArrayList<Node> nodes = new ArrayList<Node>(20);
        SequenceIterator iter = Value.asIterator(value);
        while ((item = iter.next()) != null) {
            if (item instanceof VirtualNode) {
                Object o = ((VirtualNode)item).getRealNode();
                if (o instanceof Node) {
                    nodes.add((Node)o);
                    continue;
                }
                if (!requireDOM) continue;
                throw new XPathException("Cannot convert XPath value to Java object: required class is " + target.getName() + "; supplied value has type " + Type.displayTypeName(item));
            }
            if (requireDOM) {
                if (item instanceof NodeInfo) {
                    nodes.add(NodeOverNodeInfo.wrap((NodeInfo)item));
                    continue;
                }
                throw new XPathException("Cannot convert XPath value to Java object: required class is " + target.getName() + "; supplied value has type " + Type.displayTypeName(item));
            }
            return null;
        }
        if (nodes.size() == 0 && !requireDOM) {
            return null;
        }
        if (Node.class.isAssignableFrom(target)) {
            if (nodes.size() != 1) {
                throw new XPathException("Cannot convert XPath value to Java object: requires a single DOM Nodebut supplied value contains " + nodes.size() + " nodes");
            }
            return nodes.get(0);
        }
        if (target == NodeList.class) {
            return new DOMNodeList(nodes);
        }
        if (target.isArray() && target.getComponentType() == Node.class) {
            return nodes.toArray(new Node[nodes.size()]);
        }
        if (target.isAssignableFrom(ArrayList.class)) {
            return nodes;
        }
        if (target.isAssignableFrom(HashSet.class)) {
            return new HashSet<Node>(nodes);
        }
        return null;
    }
}

