/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import javax.xml.transform.SourceLocator;
import net.sf.saxon.CollectionURIResolver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.PathMap;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Document;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AnyURIValue;

public class Collection
extends SystemFunction {
    private String expressionBaseURI = null;

    public String getStaticBaseURI() {
        return this.expressionBaseURI;
    }

    @Override
    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        if (this.expressionBaseURI == null) {
            super.checkArguments(visitor);
            this.expressionBaseURI = visitor.getStaticContext().getBaseURI();
        }
    }

    @Override
    public int computeSpecialProperties() {
        return super.computeSpecialProperties() & 0xFFBFFFFF & 0x20000 & 0x80000;
    }

    @Override
    public Expression preEvaluate(ExpressionVisitor visitor) {
        return this;
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        return this.addDocToPathMap(pathMap, pathMapNodeSet);
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        SequenceIterator iter;
        String href = this.getNumberOfArguments() == 0 ? context.getConfiguration().getDefaultCollection() : this.argument[0].evaluateItem(context).getStringValue();
        CollectionURIResolver resolver = context.getConfiguration().getCollectionURIResolver();
        try {
            iter = resolver.resolve(href, this.expressionBaseURI, context);
        }
        catch (XPathException e) {
            e.setLocator(this);
            throw e;
        }
        return Collection.getResolverResults(iter, this.expressionBaseURI, context, this);
    }

    public static SequenceIterator getResolverResults(SequenceIterator iter, final String baseURI, final XPathContext context, final SourceLocator locator) {
        if (iter == null) {
            return EmptyIterator.getInstance();
        }
        ItemMappingFunction imf = new ItemMappingFunction(){

            @Override
            public Item map(Item item) throws XPathException {
                if (item instanceof NodeInfo) {
                    return item;
                }
                if (item instanceof AnyURIValue) {
                    return Document.makeDoc(item.getStringValue(), baseURI, context, locator);
                }
                throw new XPathException("Value returned by CollectionURIResolver must be an anyURI or a NodeInfo");
            }
        };
        return new ItemMappingIterator(iter, imf);
    }
}

