/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.io.Serializable;
import java.util.Arrays;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.sort.IntIterator;
import net.sf.saxon.sort.IntSet;

public class IntHashSet
implements IntSet,
Serializable {
    private static final int NBIT = 30;
    public static final int MAX_SIZE = 0x40000000;
    public final int ndv;
    private int _nmax;
    private int _size;
    private int _nlo;
    private int _nhi;
    private int _shift;
    private int _mask;
    private int[] _values;

    public IntHashSet() {
        this(8, Integer.MIN_VALUE);
    }

    public IntHashSet(int capacity) {
        this(capacity, Integer.MIN_VALUE);
    }

    public IntHashSet(int capacity, int noDataValue) {
        this.ndv = noDataValue;
        this.setCapacity(capacity);
    }

    @Override
    public void clear() {
        this._size = 0;
        int i = 0;
        while (i < this._nmax) {
            this._values[i] = this.ndv;
            ++i;
        }
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public boolean isEmpty() {
        return this._size == 0;
    }

    public int getFirst(int defaultValue) {
        int v = 0;
        while (v < this._values.length) {
            if (this._values[v] != this.ndv) {
                return this._values[v];
            }
            ++v;
        }
        return defaultValue;
    }

    public int[] getValues() {
        int index = 0;
        int[] values = new int[this._size];
        int v = 0;
        while (v < this._values.length) {
            if (this._values[v] != this.ndv) {
                values[index++] = this._values[v];
            }
            ++v;
        }
        return values;
    }

    @Override
    public boolean contains(int value) {
        return this._values[this.indexOf(value)] != this.ndv;
    }

    @Override
    public boolean remove(int value) {
        int i = this.indexOf(value);
        if (this._values[i] == this.ndv) {
            return false;
        }
        --this._size;
        while (true) {
            int r;
            this._values[i] = this.ndv;
            int j = i;
            do {
                if (this._values[i = i - 1 & this._mask] != this.ndv) continue;
                return true;
            } while (i <= (r = this.hash(this._values[i])) && r < j || r < j && j < i || j < i && i <= r);
            this._values[j] = this._values[i];
        }
    }

    @Override
    public boolean add(int value) {
        if (value == this.ndv) {
            throw new IllegalArgumentException("Can't add the 'no data' value");
        }
        int i = this.indexOf(value);
        if (this._values[i] == this.ndv) {
            ++this._size;
            this._values[i] = value;
            if (this._size > 0x40000000) {
                throw new RuntimeException("Too many elements (> 1073741824)");
            }
            if (this._nlo < this._size && this._size <= this._nhi) {
                this.setCapacity(this._size);
            }
            return true;
        }
        return false;
    }

    private int hash(int key) {
        return 1327217885 * key >> this._shift & this._mask;
    }

    private int indexOf(int value) {
        int i = this.hash(value);
        while (this._values[i] != this.ndv) {
            if (this._values[i] == value) {
                return i;
            }
            i = i - 1 & this._mask;
        }
        return i;
    }

    private void setCapacity(int capacity) {
        if (capacity < this._size) {
            capacity = this._size;
        }
        int nbit = 1;
        int nmax = 2;
        while (nmax < capacity * 4 && nmax < 0x40000000) {
            ++nbit;
            nmax *= 2;
        }
        int nold = this._nmax;
        if (nmax == nold) {
            return;
        }
        this._nmax = nmax;
        this._nlo = nmax / 4;
        this._nhi = 0x10000000;
        this._shift = 31 - nbit;
        this._mask = nmax - 1;
        this._size = 0;
        int[] values = this._values;
        this._values = new int[nmax];
        Arrays.fill(this._values, this.ndv);
        if (values != null) {
            int i = 0;
            while (i < nold) {
                int value = values[i];
                if (value != this.ndv) {
                    ++this._size;
                    this._values[this.indexOf((int)value)] = value;
                }
                ++i;
            }
        }
    }

    @Override
    public IntIterator iterator() {
        return new IntHashSetIterator();
    }

    public IntHashSet copy() {
        IntHashSet n = new IntHashSet(this.size());
        IntIterator it = this.iterator();
        while (it.hasNext()) {
            n.add(it.next());
        }
        return n;
    }

    public IntHashSet union(IntHashSet other) {
        IntHashSet n = new IntHashSet(this.size() + other.size());
        IntIterator it = this.iterator();
        while (it.hasNext()) {
            n.add(it.next());
        }
        it = other.iterator();
        while (it.hasNext()) {
            n.add(it.next());
        }
        return n;
    }

    public IntHashSet intersect(IntHashSet other) {
        IntHashSet n = new IntHashSet(this.size());
        IntIterator it = this.iterator();
        while (it.hasNext()) {
            int v = it.next();
            if (!other.contains(v)) continue;
            n.add(v);
        }
        return n;
    }

    public IntHashSet except(IntHashSet other) {
        IntHashSet n = new IntHashSet(this.size());
        IntIterator it = this.iterator();
        while (it.hasNext()) {
            int v = it.next();
            if (other.contains(v)) continue;
            n.add(v);
        }
        return n;
    }

    @Override
    public boolean containsAll(IntSet other) {
        IntIterator it = other.iterator();
        while (it.hasNext()) {
            if (this.contains(it.next())) continue;
            return false;
        }
        return true;
    }

    public boolean containsSome(IntHashSet other) {
        IntIterator it = other.iterator();
        while (it.hasNext()) {
            if (!this.contains(it.next())) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object other) {
        if (other instanceof IntSet) {
            IntHashSet s = (IntHashSet)other;
            return this.size() == s.size() && this.containsAll(s);
        }
        return false;
    }

    public int hashCode() {
        int h = 936247625;
        IntIterator it = this.iterator();
        while (it.hasNext()) {
            h += it.next();
        }
        return h;
    }

    public void diagnosticDump() {
        System.err.println("Contents of IntHashSet");
        FastStringBuffer sb = new FastStringBuffer(100);
        int i = 0;
        while (i < this._values.length) {
            if (i % 10 == 0) {
                System.err.println(sb.toString());
                sb.setLength(0);
            }
            if (this._values[i] == this.ndv) {
                sb.append("*, ");
            } else {
                sb.append(String.valueOf(this._values[i]) + ", ");
            }
            ++i;
        }
        System.err.println(sb.toString());
        sb.setLength(0);
        System.err.println("size: " + this._size);
        System.err.println("ndv: " + this.ndv);
        System.err.println("nlo: " + this._nlo);
        System.err.println("nhi: " + this._nhi);
        System.err.println("nmax: " + this._nmax);
        System.err.println("shift: " + this._shift);
        System.err.println("mask: " + this._mask);
        System.err.println("Result of iterator:");
        IntIterator iter = this.iterator();
        int i2 = 0;
        while (iter.hasNext()) {
            if (i2++ % 10 == 0) {
                System.err.println(sb.toString());
                sb.setLength(0);
            }
            sb.append(String.valueOf(iter.next()) + ", ");
        }
        System.err.println(sb.toString());
        System.err.println("=====================");
    }

    private class IntHashSetIterator
    implements IntIterator,
    Serializable {
        private int i = 0;

        @Override
        public boolean hasNext() {
            while (this.i < IntHashSet.this._values.length) {
                if (IntHashSet.this._values[this.i] != IntHashSet.this.ndv) {
                    return true;
                }
                ++this.i;
            }
            return false;
        }

        @Override
        public int next() {
            return IntHashSet.this._values[this.i++];
        }
    }
}

