/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import net.sf.saxon.charcode.CharacterSet;
import net.sf.saxon.charcode.UTF16CharacterSet;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.tinytree.CharSlice;
import net.sf.saxon.trans.XPathException;

public class CDATAFilter
extends ProxyReceiver {
    private FastStringBuffer buffer = new FastStringBuffer(256);
    private Stack stack = new Stack();
    private int[] nameList;
    private CharacterSet characterSet;

    public void setOutputProperties(Properties details) throws XPathException {
        this.nameList = this.getCdataElements(details);
        this.characterSet = this.getConfiguration().getCharacterSetFactory().getCharacterSet(details);
    }

    @Override
    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        this.flush();
        this.stack.push(new Integer(nameCode & 0xFFFFF));
        this.nextReceiver.startElement(nameCode, typeCode, locationId, properties);
    }

    @Override
    public void endElement() throws XPathException {
        this.flush();
        this.stack.pop();
        this.nextReceiver.endElement();
    }

    @Override
    public void processingInstruction(String target, CharSequence data, int locationId, int properties) throws XPathException {
        this.flush();
        this.nextReceiver.processingInstruction(target, data, locationId, properties);
    }

    @Override
    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        if ((properties & 1) == 0) {
            this.buffer.append(chars.toString());
        } else {
            this.flush();
            this.nextReceiver.characters(chars, locationId, properties);
        }
    }

    @Override
    public void comment(CharSequence chars, int locationId, int properties) throws XPathException {
        this.flush();
        this.nextReceiver.comment(chars, locationId, properties);
    }

    private void flush() throws XPathException {
        boolean cdata;
        int end = this.buffer.length();
        if (end == 0) {
            return;
        }
        if (this.stack.isEmpty()) {
            cdata = false;
        } else {
            int fprint = (Integer)this.stack.peek();
            cdata = this.isCDATA(fprint);
        }
        if (cdata) {
            int start = 0;
            int k = 0;
            while (k < end) {
                int next = this.buffer.charAt(k);
                int skip = 1;
                if (UTF16CharacterSet.isHighSurrogate((char)next)) {
                    next = UTF16CharacterSet.combinePair((char)next, this.buffer.charAt(k + 1));
                    skip = 2;
                }
                if (next != 0 && this.characterSet.inCharset(next)) {
                    ++k;
                    continue;
                }
                char[] array = new char[k - start];
                this.buffer.getChars(start, k, array, 0);
                this.flushCDATA(array, k - start);
                while (k < end) {
                    this.nextReceiver.characters(this.buffer.subSequence(k, k + skip), 0, 2);
                    if ((k += skip) >= end) break;
                    next = this.buffer.charAt(k);
                    skip = 1;
                    if (UTF16CharacterSet.isHighSurrogate((char)next)) {
                        next = UTF16CharacterSet.combinePair((char)next, this.buffer.charAt(k + 1));
                        skip = 2;
                    }
                    if (this.characterSet.inCharset(next)) break;
                }
                start = k;
            }
            char[] rest = new char[end - start];
            this.buffer.getChars(start, end, rest, 0);
            this.flushCDATA(rest, end - start);
        } else {
            this.nextReceiver.characters(this.buffer, 0, 0);
        }
        this.buffer.setLength(0);
    }

    private void flushCDATA(char[] array, int len) throws XPathException {
        if (len == 0) {
            return;
        }
        this.nextReceiver.characters("<![CDATA[", 0, 3);
        int i = 0;
        int doneto = 0;
        while (i < len - 2) {
            if (array[i] == ']' && array[i + 1] == ']' && array[i + 2] == '>') {
                this.nextReceiver.characters(new CharSlice(array, doneto, i + 2 - doneto), 0, 3);
                this.nextReceiver.characters("]]><![CDATA[", 0, 3);
                doneto = i + 2;
            } else if (array[i] == '\u0000') {
                this.nextReceiver.characters(new CharSlice(array, doneto, i - doneto), 0, 3);
                doneto = i + 1;
            }
            ++i;
        }
        this.nextReceiver.characters(new CharSlice(array, doneto, len - doneto), 0, 3);
        this.nextReceiver.characters("]]>", 0, 3);
    }

    private boolean isCDATA(int fingerprint) {
        int i = 0;
        while (i < this.nameList.length) {
            if (this.nameList[i] == fingerprint) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private int[] getCdataElements(Properties details) {
        String cdata = details.getProperty("cdata-section-elements");
        if (cdata == null) {
            return new int[0];
        }
        int count = 0;
        StringTokenizer st1 = new StringTokenizer(cdata, " \t\n\r", false);
        while (st1.hasMoreTokens()) {
            st1.nextToken();
            ++count;
        }
        int[] array = new int[count];
        count = 0;
        StringTokenizer st2 = new StringTokenizer(cdata, " \t\n\r", false);
        while (st2.hasMoreTokens()) {
            String expandedName = st2.nextToken();
            array[count++] = this.getNamePool().allocateClarkName(expandedName);
        }
        return array;
    }
}

