/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.configuration;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.mockito.configuration.AnnotationEngine;
import org.mockito.exceptions.Reporter;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.configuration.CaptorAnnotationProcessor;
import org.mockito.internal.configuration.FieldAnnotationProcessor;
import org.mockito.internal.configuration.MockAnnotationProcessor;
import org.mockito.internal.configuration.MockitoAnnotationsMockAnnotationProcessor;
import org.mockito.internal.util.reflection.FieldSetter;

public class DefaultAnnotationEngine
implements AnnotationEngine {
    private final Map<Class<? extends Annotation>, FieldAnnotationProcessor<?>> annotationProcessorMap = new HashMap();

    public DefaultAnnotationEngine() {
        this.registerAnnotationProcessor(Mock.class, new MockAnnotationProcessor());
        this.registerAnnotationProcessor(MockitoAnnotations.Mock.class, new MockitoAnnotationsMockAnnotationProcessor());
        this.registerAnnotationProcessor(Captor.class, new CaptorAnnotationProcessor());
    }

    @Override
    public Object createMockFor(Annotation annotation, Field field) {
        return this.forAnnotation(annotation).process(annotation, field);
    }

    private <A extends Annotation> FieldAnnotationProcessor<A> forAnnotation(A annotation) {
        if (this.annotationProcessorMap.containsKey(annotation.annotationType())) {
            return this.annotationProcessorMap.get(annotation.annotationType());
        }
        return new FieldAnnotationProcessor<A>(){

            @Override
            public Object process(A annotation, Field field) {
                return null;
            }
        };
    }

    private <A extends Annotation> void registerAnnotationProcessor(Class<A> annotationClass, FieldAnnotationProcessor<A> fieldAnnotationProcessor) {
        this.annotationProcessorMap.put(annotationClass, fieldAnnotationProcessor);
    }

    @Override
    public void process(Class<?> clazz, Object testInstance) {
        Field[] fields;
        Field[] fieldArray = fields = clazz.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            boolean alreadyAssigned = false;
            Annotation[] annotationArray = field.getAnnotations();
            int n3 = annotationArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Annotation annotation = annotationArray[n4];
                Object mock = this.createMockFor(annotation, field);
                if (mock != null) {
                    this.throwIfAlreadyAssigned(field, alreadyAssigned);
                    alreadyAssigned = true;
                    try {
                        new FieldSetter(testInstance, field).set(mock);
                    }
                    catch (Exception e) {
                        throw new MockitoException("Problems setting field " + field.getName() + " annotated with " + annotation, e);
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    void throwIfAlreadyAssigned(Field field, boolean alreadyAssigned) {
        if (alreadyAssigned) {
            new Reporter().moreThanOneAnnotationNotAllowed(field.getName());
        }
    }
}

