/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import java.util.List;
import org.assertj.core.api.AbstractIterableAssert;
import org.assertj.core.api.Condition;
import org.assertj.core.api.IndexedObjectEnumerableAssert;
import org.assertj.core.data.Index;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.Lists;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractListAssert<S extends AbstractListAssert<S, A, T>, A extends List<? extends T>, T>
extends AbstractIterableAssert<S, A, T>
implements IndexedObjectEnumerableAssert<S, T> {
    @VisibleForTesting
    Lists lists = Lists.instance();

    protected AbstractListAssert(A actual, Class<?> selfType) {
        super(actual, selfType);
    }

    @Override
    public S contains(T value, Index index) {
        this.lists.assertContains(this.info, (List)this.actual, value, index);
        return (S)((AbstractListAssert)this.myself);
    }

    @Override
    public S doesNotContain(T value, Index index) {
        this.lists.assertDoesNotContain(this.info, (List)this.actual, value, index);
        return (S)((AbstractListAssert)this.myself);
    }

    public S has(Condition<? super T> condition, Index index) {
        this.lists.assertHas(this.info, (List)this.actual, condition, index);
        return (S)((AbstractListAssert)this.myself);
    }

    public S is(Condition<? super T> condition, Index index) {
        this.lists.assertIs(this.info, (List)this.actual, condition, index);
        return (S)((AbstractListAssert)this.myself);
    }

    public S isSorted() {
        this.lists.assertIsSorted(this.info, (List)this.actual);
        return (S)((AbstractListAssert)this.myself);
    }

    public S isSortedAccordingTo(Comparator<? super T> comparator) {
        this.lists.assertIsSortedAccordingToComparator(this.info, (List)this.actual, comparator);
        return (S)((AbstractListAssert)this.myself);
    }

    @Override
    public S usingElementComparator(Comparator<? super T> customComparator) {
        super.usingElementComparator((Comparator)customComparator);
        this.lists = new Lists(new ComparatorBasedComparisonStrategy(customComparator));
        return (S)((AbstractListAssert)this.myself);
    }

    @Override
    public S usingDefaultElementComparator() {
        super.usingDefaultElementComparator();
        this.lists = Lists.instance();
        return (S)((AbstractListAssert)this.myself);
    }

    @Override
    protected S usingComparisonStrategy(ComparisonStrategy comparisonStrategy) {
        super.usingComparisonStrategy(comparisonStrategy);
        this.lists = new Lists(comparisonStrategy);
        return (S)((AbstractListAssert)this.myself);
    }
}

