/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.debugging;

import java.util.Arrays;
import java.util.List;
import org.mockito.MockitoDebugger;
import org.mockito.internal.invocation.UnusedStubsFinder;
import org.mockito.internal.invocation.finder.AllInvocationsFinder;
import org.mockito.invocation.Invocation;

public class MockitoDebuggerImpl
implements MockitoDebugger {
    private AllInvocationsFinder allInvocationsFinder = new AllInvocationsFinder();
    private UnusedStubsFinder unusedStubsFinder = new UnusedStubsFinder();

    @Override
    public String printInvocations(Object ... mocks) {
        String out = "";
        List<Invocation> invocations = this.allInvocationsFinder.find(Arrays.asList(mocks));
        out = String.valueOf(out) + this.line("********************************");
        out = String.valueOf(out) + this.line("*** Mockito interactions log ***");
        out = String.valueOf(out) + this.line("********************************");
        for (Invocation i : invocations) {
            out = String.valueOf(out) + this.line(i.toString());
            out = String.valueOf(out) + this.line(" invoked: " + i.getLocation());
            if (i.stubInfo() == null) continue;
            out = String.valueOf(out) + this.line(" stubbed: " + i.stubInfo().stubbedAt().toString());
        }
        invocations = this.unusedStubsFinder.find(Arrays.asList(mocks));
        if (invocations.isEmpty()) {
            return this.print(out);
        }
        out = String.valueOf(out) + this.line("********************************");
        out = String.valueOf(out) + this.line("***       Unused stubs       ***");
        out = String.valueOf(out) + this.line("********************************");
        for (Invocation i : invocations) {
            out = String.valueOf(out) + this.line(i.toString());
            out = String.valueOf(out) + this.line(" stubbed: " + i.getLocation());
        }
        return this.print(out);
    }

    private String line(String text) {
        return String.valueOf(text) + "\n";
    }

    private String print(String out) {
        System.out.println(out);
        return out;
    }
}

