/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.invocation;

import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.mockito.internal.matchers.ArrayEquals;
import org.mockito.internal.matchers.Equals;
import org.mockito.internal.util.collections.ArrayUtils;

public class ArgumentsProcessor {
    public static Object[] expandVarArgs(boolean isVarArgs, Object[] args) {
        if (!isVarArgs || new ArrayUtils().isEmpty(args) || args[args.length - 1] != null && !args[args.length - 1].getClass().isArray()) {
            return args == null ? new Object[]{} : args;
        }
        int nonVarArgsCount = args.length - 1;
        Object[] varArgs = args[nonVarArgsCount] == null ? new Object[1] : ArrayEquals.createObjectArray(args[nonVarArgsCount]);
        int varArgsCount = varArgs.length;
        Object[] newArgs = new Object[nonVarArgsCount + varArgsCount];
        System.arraycopy(args, 0, newArgs, 0, nonVarArgsCount);
        System.arraycopy(varArgs, 0, newArgs, nonVarArgsCount, varArgsCount);
        return newArgs;
    }

    public static List<Matcher> argumentsToMatchers(Object[] arguments) {
        ArrayList<Matcher> matchers = new ArrayList<Matcher>(arguments.length);
        Object[] objectArray = arguments;
        int n = arguments.length;
        int n2 = 0;
        while (n2 < n) {
            Object arg = objectArray[n2];
            if (arg != null && arg.getClass().isArray()) {
                matchers.add(new ArrayEquals(arg));
            } else {
                matchers.add(new Equals(arg));
            }
            ++n2;
        }
        return matchers;
    }
}

