/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.matchers;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.hamcrest.Description;
import org.mockito.internal.matchers.Equals;

public class ArrayEquals
extends Equals {
    private static final long serialVersionUID = -7167812844261087583L;

    public ArrayEquals(Object wanted) {
        super(wanted);
    }

    @Override
    public boolean matches(Object actual) {
        Object wanted = this.getWanted();
        if (wanted == null || actual == null) {
            return super.matches(actual);
        }
        if (wanted instanceof boolean[] && actual instanceof boolean[]) {
            return Arrays.equals((boolean[])wanted, (boolean[])actual);
        }
        if (wanted instanceof byte[] && actual instanceof byte[]) {
            return Arrays.equals((byte[])wanted, (byte[])actual);
        }
        if (wanted instanceof char[] && actual instanceof char[]) {
            return Arrays.equals((char[])wanted, (char[])actual);
        }
        if (wanted instanceof double[] && actual instanceof double[]) {
            return Arrays.equals((double[])wanted, (double[])actual);
        }
        if (wanted instanceof float[] && actual instanceof float[]) {
            return Arrays.equals((float[])wanted, (float[])actual);
        }
        if (wanted instanceof int[] && actual instanceof int[]) {
            return Arrays.equals((int[])wanted, (int[])actual);
        }
        if (wanted instanceof long[] && actual instanceof long[]) {
            return Arrays.equals((long[])wanted, (long[])actual);
        }
        if (wanted instanceof short[] && actual instanceof short[]) {
            return Arrays.equals((short[])wanted, (short[])actual);
        }
        if (wanted instanceof Object[] && actual instanceof Object[]) {
            return Arrays.equals((Object[])wanted, (Object[])actual);
        }
        return false;
    }

    @Override
    public void describeTo(Description description) {
        if (this.getWanted() != null && this.getWanted().getClass().isArray()) {
            this.appendArray(ArrayEquals.createObjectArray(this.getWanted()), description);
        } else {
            super.describeTo(description);
        }
    }

    private void appendArray(Object[] array, Description description) {
        description.appendText("[");
        int i = 0;
        while (i < array.length) {
            new Equals(array[i]).describeTo(description);
            if (i != array.length - 1) {
                description.appendText(", ");
            }
            ++i;
        }
        description.appendText("]");
    }

    public static Object[] createObjectArray(Object array) {
        if (array instanceof Object[]) {
            return (Object[])array;
        }
        Object[] result = new Object[Array.getLength(array)];
        int i = 0;
        while (i < Array.getLength(array)) {
            result[i] = Array.get(array, i);
            ++i;
        }
        return result;
    }
}

