/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.stubbing;

import org.mockito.internal.stubbing.answers.CallsRealMethods;
import org.mockito.internal.stubbing.answers.Returns;
import org.mockito.internal.stubbing.answers.ThrowsException;
import org.mockito.internal.stubbing.answers.ThrowsExceptionClass;
import org.mockito.stubbing.DeprecatedOngoingStubbing;
import org.mockito.stubbing.OngoingStubbing;

public abstract class BaseStubbing<T>
implements OngoingStubbing<T>,
DeprecatedOngoingStubbing<T> {
    @Override
    public OngoingStubbing<T> thenReturn(T value) {
        return this.thenAnswer(new Returns(value));
    }

    @Override
    public OngoingStubbing<T> thenReturn(T value, T ... values) {
        OngoingStubbing<T> stubbing = this.thenReturn(value);
        if (values == null) {
            return stubbing.thenReturn(null);
        }
        T[] TArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            T v = TArray[n2];
            stubbing = stubbing.thenReturn(v);
            ++n2;
        }
        return stubbing;
    }

    private OngoingStubbing<T> thenThrow(Throwable throwable) {
        return this.thenAnswer(new ThrowsException(throwable));
    }

    @Override
    public OngoingStubbing<T> thenThrow(Throwable ... throwables) {
        if (throwables == null) {
            this.thenThrow((Throwable)null);
        }
        OngoingStubbing<T> stubbing = null;
        Throwable[] throwableArray = throwables;
        int n = throwables.length;
        int n2 = 0;
        while (n2 < n) {
            Throwable t = throwableArray[n2];
            stubbing = stubbing == null ? this.thenThrow(t) : stubbing.thenThrow(t);
            ++n2;
        }
        return stubbing;
    }

    private OngoingStubbing<T> thenThrow(Class<? extends Throwable> throwableClass) {
        return this.thenAnswer(new ThrowsExceptionClass(throwableClass));
    }

    @Override
    public OngoingStubbing<T> thenThrow(Class<? extends Throwable> ... throwableClasses) {
        if (throwableClasses == null) {
            this.thenThrow((Throwable)null);
        }
        OngoingStubbing<T> stubbing = null;
        Class<? extends Throwable>[] classArray = throwableClasses;
        int n = throwableClasses.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends Throwable> t = classArray[n2];
            stubbing = stubbing == null ? this.thenThrow(t) : stubbing.thenThrow(t);
            ++n2;
        }
        return stubbing;
    }

    @Override
    public OngoingStubbing<T> thenCallRealMethod() {
        return this.thenAnswer(new CallsRealMethods());
    }

    @Override
    public DeprecatedOngoingStubbing<T> toReturn(T value) {
        return this.toAnswer(new Returns(value));
    }

    @Override
    public DeprecatedOngoingStubbing<T> toThrow(Throwable throwable) {
        return this.toAnswer(new ThrowsException(throwable));
    }
}

