/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.stubbing.answers;

import java.lang.reflect.Method;
import org.mockito.internal.util.Primitives;
import org.mockito.invocation.Invocation;

public class MethodInfo {
    private Method method;

    public MethodInfo(Invocation theInvocation) {
        this.method = theInvocation.getMethod();
    }

    public boolean isValidException(Throwable throwable) {
        Class<?>[] exceptions = this.method.getExceptionTypes();
        Class<?> throwableClass = throwable.getClass();
        Class<?>[] classArray = exceptions;
        int n = exceptions.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> exception = classArray[n2];
            if (exception.isAssignableFrom(throwableClass)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isValidReturnType(Class clazz) {
        if (this.method.getReturnType().isPrimitive() || clazz.isPrimitive()) {
            return Primitives.primitiveTypeOf(clazz) == Primitives.primitiveTypeOf(this.method.getReturnType());
        }
        return this.method.getReturnType().isAssignableFrom(clazz);
    }

    public boolean isVoid() {
        return this.method.getReturnType() == Void.TYPE;
    }

    public String printMethodReturnType() {
        return this.method.getReturnType().getSimpleName();
    }

    public String getMethodName() {
        return this.method.getName();
    }

    public boolean returnsPrimitive() {
        return this.method.getReturnType().isPrimitive();
    }

    public Method getMethod() {
        return this.method;
    }

    public boolean isDeclaredOnInterface() {
        return this.method.getDeclaringClass().isInterface();
    }
}

