/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.stubbing.defaultanswers;

import java.io.Serializable;
import java.lang.reflect.Modifier;
import org.mockito.Mockito;
import org.mockito.exceptions.Reporter;
import org.mockito.internal.debugging.LocationImpl;
import org.mockito.internal.stubbing.defaultanswers.ReturnsMoreEmptyValues;
import org.mockito.internal.util.ObjectMethodsGuru;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.invocation.Location;
import org.mockito.stubbing.Answer;

public class ReturnsSmartNulls
implements Answer<Object>,
Serializable {
    private static final long serialVersionUID = 7618312406617949441L;
    private final Answer<Object> delegate = new ReturnsMoreEmptyValues();

    @Override
    public Object answer(InvocationOnMock invocation) throws Throwable {
        Object defaultReturnValue = this.delegate.answer(invocation);
        if (defaultReturnValue != null) {
            return defaultReturnValue;
        }
        Class<?> type = invocation.getMethod().getReturnType();
        if (!type.isPrimitive() && !Modifier.isFinal(type.getModifiers())) {
            LocationImpl location = new LocationImpl();
            return Mockito.mock(type, new ThrowsSmartNullPointer(invocation, location));
        }
        return null;
    }

    private static class ThrowsSmartNullPointer
    implements Answer {
        private final InvocationOnMock unstubbedInvocation;
        private final Location location;

        public ThrowsSmartNullPointer(InvocationOnMock unstubbedInvocation, Location location) {
            this.unstubbedInvocation = unstubbedInvocation;
            this.location = location;
        }

        public Object answer(InvocationOnMock currentInvocation) throws Throwable {
            if (new ObjectMethodsGuru().isToString(currentInvocation.getMethod())) {
                return "SmartNull returned by this unstubbed method call on a mock:\n" + this.unstubbedInvocation.toString();
            }
            new Reporter().smartNullPointerException(this.unstubbedInvocation.toString(), this.location);
            return null;
        }
    }
}

