/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.verification.checkers;

import java.util.List;
import org.mockito.exceptions.Reporter;
import org.mockito.internal.invocation.CapturesArgumensFromInvocation;
import org.mockito.internal.invocation.InvocationMarker;
import org.mockito.internal.invocation.InvocationMatcher;
import org.mockito.internal.invocation.InvocationsFinder;
import org.mockito.internal.verification.checkers.AtLeastDiscrepancy;
import org.mockito.invocation.Invocation;
import org.mockito.invocation.Location;

public class AtLeastXNumberOfInvocationsChecker {
    Reporter reporter = new Reporter();
    InvocationsFinder finder = new InvocationsFinder();
    InvocationMarker invocationMarker = new InvocationMarker();

    public void check(List<Invocation> invocations, InvocationMatcher wanted, int wantedCount) {
        List<Invocation> actualInvocations = this.finder.findInvocations(invocations, wanted);
        int actualCount = actualInvocations.size();
        if (wantedCount > actualCount) {
            Location lastLocation = this.finder.getLastLocation(actualInvocations);
            this.reporter.tooLittleActualInvocations(new AtLeastDiscrepancy(wantedCount, actualCount), wanted, lastLocation);
        }
        this.invocationMarker.markVerified(actualInvocations, (CapturesArgumensFromInvocation)wanted);
    }
}

