/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.assertj.core.presentation.Representation;
import org.assertj.core.util.GroupFormatUtil;
import org.assertj.core.util.Lists;

public final class IterableUtil
extends GroupFormatUtil {
    public static boolean isNullOrEmpty(Iterable<?> iterable) {
        if (iterable == null) {
            return true;
        }
        if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
            return true;
        }
        return !iterable.iterator().hasNext();
    }

    public static int sizeOf(Iterable<?> iterable) {
        if (iterable == null) {
            throw new NullPointerException("Iterable must not be null");
        }
        if (iterable instanceof Collection) {
            return ((Collection)iterable).size();
        }
        int size = 0;
        Iterator<?> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            ++size;
            iterator.next();
        }
        return size;
    }

    public static <T> List<T> nonNullElementsIn(Iterable<? extends T> i) {
        if (IterableUtil.isNullOrEmpty(i)) {
            return Collections.emptyList();
        }
        ArrayList<T> nonNull = new ArrayList<T>();
        for (T element : i) {
            if (element == null) continue;
            nonNull.add(element);
        }
        return nonNull;
    }

    public static <T> T[] toArray(Iterable<? extends T> iterable) {
        if (iterable == null) {
            return null;
        }
        return Lists.newArrayList(iterable).toArray();
    }

    public static <T> T[] toArray(Iterable<? extends T> iterable, Class<T> type) {
        if (iterable == null) {
            return null;
        }
        Collection<T> collection = IterableUtil.toCollection(iterable);
        T[] array = IterableUtil.newArray(type, collection.size());
        return collection.toArray(array);
    }

    private static <T> Collection<T> toCollection(Iterable<T> iterable) {
        return iterable instanceof Collection ? (ArrayList<T>)iterable : Lists.newArrayList(iterable);
    }

    private static <T> T[] newArray(Class<T> type, int length) {
        return (Object[])Array.newInstance(type, length);
    }

    public static String smartFormat(Representation representation, Iterable<?> iterable) {
        String singleLineDescription = IterableUtil.singleLineFormat(representation, iterable, "[", "]");
        return IterableUtil.doesDescriptionFitOnSingleLine(singleLineDescription) ? singleLineDescription : IterableUtil.multiLineFormat(representation, iterable);
    }

    public static String singleLineFormat(Representation representation, Iterable<?> iterable, String start, String end) {
        return IterableUtil.format(representation, iterable, start, end, ",", " ");
    }

    public static String multiLineFormat(Representation representation, Iterable<?> iterable) {
        return IterableUtil.format(representation, iterable, "[", "]", ELEMENT_SEPARATOR_WITH_NEWLINE, "    ");
    }

    private static boolean doesDescriptionFitOnSingleLine(String singleLineDescription) {
        return singleLineDescription == null || singleLineDescription.length() < maxLengthForSingleLineDescription;
    }

    private static String format(Representation representation, Iterable<?> iterable, String start, String end, String elementSeparator, String indentation) {
        if (iterable == null) {
            return null;
        }
        Iterator<?> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return start + end;
        }
        StringBuilder desc = new StringBuilder(start);
        boolean firstElement = true;
        while (true) {
            Object element = iterator.next();
            if (firstElement) {
                firstElement = false;
            } else {
                desc.append(indentation);
            }
            desc.append(element == iterable ? "(this Collection)" : representation.toStringOf(element));
            if (!iterator.hasNext()) {
                return desc.append(end).toString();
            }
            desc.append(elementSeparator);
        }
    }

    private IterableUtil() {
    }
}

