/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jsonschema2pojo.ContentResolver;
import org.jsonschema2pojo.FragmentResolver;
import org.jsonschema2pojo.Schema;

public class SchemaStore {
    protected Map<URI, Schema> schemas = new HashMap<URI, Schema>();
    protected FragmentResolver fragmentResolver = new FragmentResolver();
    protected ContentResolver contentResolver = new ContentResolver();

    public synchronized Schema create(URI id) {
        if (!this.schemas.containsKey(id)) {
            JsonNode content = this.contentResolver.resolve(this.removeFragment(id));
            if (id.toString().contains("#")) {
                content = this.fragmentResolver.resolve(content, '#' + StringUtils.substringAfter((String)id.toString(), (String)"#"));
            }
            this.schemas.put(id, new Schema(id, content));
        }
        return this.schemas.get(id);
    }

    protected URI removeFragment(URI id) {
        return URI.create(StringUtils.substringBefore((String)id.toString(), (String)"#"));
    }

    public Schema create(Schema parent, String path) {
        URI id;
        if (path.equals("#")) {
            return parent;
        }
        path = StringUtils.stripEnd((String)path, (String)"#?&/");
        URI uRI = id = parent == null || parent.getId() == null ? URI.create(path) : parent.getId().resolve(path);
        if (this.selfReferenceWithoutParentFile(parent, path)) {
            this.schemas.put(id, new Schema(id, this.fragmentResolver.resolve(parent.getContent(), path)));
            return this.schemas.get(id);
        }
        return this.create(id);
    }

    protected boolean selfReferenceWithoutParentFile(Schema parent, String path) {
        return parent != null && parent.getId() == null && path.startsWith("#/");
    }

    public synchronized void clearCache() {
        this.schemas.clear();
    }
}

