/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo.rules;

import com.fasterxml.jackson.databind.JsonNode;
import com.sun.codemodel.JClassContainer;
import com.sun.codemodel.JType;
import org.jsonschema2pojo.Schema;
import org.jsonschema2pojo.rules.Rule;
import org.jsonschema2pojo.rules.RuleFactory;

public class SchemaRule
implements Rule<JClassContainer, JType> {
    private final RuleFactory ruleFactory;

    protected SchemaRule(RuleFactory ruleFactory) {
        this.ruleFactory = ruleFactory;
    }

    @Override
    public JType apply(String nodeName, JsonNode schemaNode, JClassContainer generatableType, Schema schema) {
        if (schemaNode.has("$ref")) {
            schema = this.ruleFactory.getSchemaStore().create(schema, schemaNode.get("$ref").asText());
            schemaNode = schema.getContent();
            if (schema.isGenerated()) {
                return schema.getJavaType();
            }
            return this.apply(nodeName, schemaNode, generatableType, schema);
        }
        JType javaType = schemaNode.has("enum") ? this.ruleFactory.getEnumRule().apply(nodeName, schemaNode, generatableType, schema) : this.ruleFactory.getTypeRule().apply(nodeName, schemaNode, (JClassContainer)generatableType.getPackage(), schema);
        schema.setJavaTypeIfEmpty(javaType);
        return javaType;
    }
}

