/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.AugmentedSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.OutputURIResolver;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.StandardErrorListener;
import net.sf.saxon.StandardURIResolver;
import net.sf.saxon.TransformerFactoryImpl;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.CharacterMapExpander;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.Emitter;
import net.sf.saxon.event.ImplicitResultChecker;
import net.sf.saxon.event.ParseOptions;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SaxonOutputKeys;
import net.sf.saxon.event.Sender;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.SerializerFactory;
import net.sf.saxon.event.Stripper;
import net.sf.saxon.event.TransformerReceiver;
import net.sf.saxon.expr.PathMap;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.functions.Document;
import net.sf.saxon.functions.EscapeURI;
import net.sf.saxon.instruct.ApplyTemplates;
import net.sf.saxon.instruct.Bindery;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.GlobalParameterSet;
import net.sf.saxon.instruct.GlobalVariable;
import net.sf.saxon.instruct.ParameterSet;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.instruct.Template;
import net.sf.saxon.instruct.TerminationException;
import net.sf.saxon.om.AllElementStripper;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.DocumentPool;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.om.SpaceStrippedDocument;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.TreeModel;
import net.sf.saxon.om.TypeStrippedDocument;
import net.sf.saxon.om.UnfailingIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.om.VirtualNode;
import net.sf.saxon.sort.IntHashMap;
import net.sf.saxon.trace.TraceEventMulticaster;
import net.sf.saxon.trace.TraceListener;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.RuleManager;
import net.sf.saxon.trans.StandardUnparsedTextResolver;
import net.sf.saxon.trans.UnparsedTextURIResolver;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaURIResolver;
import net.sf.saxon.value.DateTimeValue;
import org.xml.sax.SAXParseException;

public class Controller
extends Transformer {
    private Configuration config;
    private Item initialContextItem;
    private Item contextForGlobalVariables;
    private Bindery bindery;
    private NamePool namePool;
    private String messageReceiverClassName;
    private Receiver messageReceiver;
    private RuleManager ruleManager;
    private Properties localOutputProperties;
    private GlobalParameterSet parameters;
    private PreparedStylesheet preparedStylesheet;
    private TraceListener traceListener;
    private boolean tracingPaused;
    private PrintStream traceFunctionDestination = System.err;
    private URIResolver standardURIResolver;
    private URIResolver userURIResolver;
    private Result principalResult;
    private String principalResultURI;
    private String cookedPrincipalResultURI;
    private boolean thereHasBeenAnExplicitResultDocument;
    private OutputURIResolver outputURIResolver;
    private UnparsedTextURIResolver unparsedTextResolver;
    private SchemaURIResolver schemaURIResolver;
    private ErrorListener errorListener;
    private int recoveryPolicy;
    private Executable executable;
    private TreeModel treeModel = TreeModel.TINY_TREE;
    private Template initialTemplate = null;
    private HashSet<String> allOutputDestinations;
    private DocumentPool sourceDocumentPool;
    private SequenceOutputter reusableSequenceOutputter = null;
    private HashMap<String, Object> userDataTable;
    private DateTimeValue currentDateTime;
    private boolean dateTimePreset = false;
    private StructuredQName initialMode = null;
    private NodeInfo lastRememberedNode = null;
    private int lastRememberedNumber = -1;
    private ClassLoader classLoader;
    private PathMap pathMap = null;
    private int validationMode;

    public Controller(Configuration config) {
        this.config = config;
        this.executable = new Executable(config);
        this.executable.setHostLanguage(config.getHostLanguage());
        this.sourceDocumentPool = new DocumentPool();
        this.reset();
    }

    public Controller(Configuration config, Executable executable) {
        this.config = config;
        this.executable = executable;
        this.sourceDocumentPool = new DocumentPool();
        this.reset();
    }

    @Override
    public void reset() {
        TraceListener tracer;
        this.bindery = new Bindery();
        this.namePool = this.config.getNamePool();
        this.standardURIResolver = this.config.getSystemURIResolver();
        this.userURIResolver = this.config.getURIResolver();
        this.outputURIResolver = this.config.getOutputURIResolver();
        this.schemaURIResolver = this.config.getSchemaURIResolver();
        this.unparsedTextResolver = new StandardUnparsedTextResolver();
        this.errorListener = this.config.getErrorListener();
        this.recoveryPolicy = this.config.getRecoveryPolicy();
        this.validationMode = this.config.getSchemaValidationMode();
        if (this.errorListener instanceof StandardErrorListener) {
            PrintStream ps = ((StandardErrorListener)this.errorListener).getErrorOutput();
            this.errorListener = ((StandardErrorListener)this.errorListener).makeAnother(this.executable.getHostLanguage());
            ((StandardErrorListener)this.errorListener).setErrorOutput(ps);
            ((StandardErrorListener)this.errorListener).setRecoveryPolicy(this.recoveryPolicy);
        }
        this.traceListener = null;
        this.traceFunctionDestination = System.err;
        try {
            tracer = this.config.makeTraceListener();
        }
        catch (XPathException err) {
            throw new IllegalStateException(err.getMessage());
        }
        if (tracer != null) {
            this.addTraceListener(tracer);
        }
        this.setTreeModel(this.config.getTreeModel());
        this.contextForGlobalVariables = null;
        this.messageReceiver = null;
        this.localOutputProperties = null;
        this.parameters = null;
        this.currentDateTime = null;
        this.dateTimePreset = false;
        this.initialContextItem = null;
        this.initialMode = null;
        this.initialTemplate = null;
        this.classLoader = null;
        this.clearPerTransformationData();
    }

    private void clearPerTransformationData() {
        this.userDataTable = new HashMap(20);
        this.principalResult = null;
        this.allOutputDestinations = null;
        this.thereHasBeenAnExplicitResultDocument = false;
        this.lastRememberedNode = null;
        this.lastRememberedNumber = -1;
        this.tracingPaused = false;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setInitialMode(String expandedModeName) {
        this.initialMode = expandedModeName == null || expandedModeName.length() == 0 ? null : StructuredQName.fromClarkName(expandedModeName);
    }

    public String getInitialMode() {
        return this.initialMode.getClarkName();
    }

    @Override
    public void setOutputProperties(Properties properties) {
        if (properties == null) {
            this.localOutputProperties = null;
        } else {
            Enumeration<?> keys = properties.propertyNames();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                this.setOutputProperty(key, properties.getProperty(key));
            }
        }
    }

    @Override
    public Properties getOutputProperties() {
        if (this.localOutputProperties == null) {
            if (this.executable == null) {
                return new Properties();
            }
            this.localOutputProperties = new Properties(this.executable.getDefaultOutputProperties());
        }
        Properties newProps = new Properties();
        Enumeration<?> keys = this.localOutputProperties.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            newProps.setProperty(key, this.localOutputProperties.getProperty(key));
        }
        return newProps;
    }

    @Override
    public void setOutputProperty(String name, String value) {
        if (this.localOutputProperties == null) {
            this.localOutputProperties = this.getOutputProperties();
        }
        try {
            SaxonOutputKeys.checkOutputProperty(name, value, this.getConfiguration());
        }
        catch (XPathException err) {
            throw new IllegalArgumentException(err.getMessage());
        }
        this.localOutputProperties.setProperty(name, value);
    }

    @Override
    public String getOutputProperty(String name) {
        try {
            SaxonOutputKeys.checkOutputProperty(name, null, this.getConfiguration());
        }
        catch (XPathException err) {
            throw new IllegalArgumentException(err.getMessage());
        }
        if (this.localOutputProperties == null) {
            if (this.executable == null) {
                return null;
            }
            this.localOutputProperties = this.executable.getDefaultOutputProperties();
        }
        return this.localOutputProperties.getProperty(name);
    }

    public void setBaseOutputURI(String uri) {
        this.principalResultURI = uri;
    }

    public String getBaseOutputURI() {
        return this.principalResultURI;
    }

    public String getCookedBaseOutputURI() {
        if (this.cookedPrincipalResultURI == null) {
            String base = this.getBaseOutputURI();
            if (base == null && this.config.isAllowExternalFunctions()) {
                base = new File(System.getProperty("user.dir")).toURI().toString();
            }
            if (base != null) {
                base = EscapeURI.iriToUri(base).toString();
            }
            this.cookedPrincipalResultURI = base;
        }
        return this.cookedPrincipalResultURI;
    }

    public Result getPrincipalResult() {
        return this.principalResult;
    }

    public boolean checkUniqueOutputDestination(String uri) {
        if (uri == null) {
            return true;
        }
        if (this.allOutputDestinations == null) {
            this.allOutputDestinations = new HashSet(20);
        }
        return !this.allOutputDestinations.contains(uri);
    }

    public void addUnavailableOutputDestination(String uri) {
        if (this.allOutputDestinations == null) {
            this.allOutputDestinations = new HashSet(20);
        }
        this.allOutputDestinations.add(uri);
    }

    public void removeUnavailableOutputDestination(String uri) {
        if (this.allOutputDestinations != null) {
            this.allOutputDestinations.remove(uri);
        }
    }

    public boolean isUnusedOutputDestination(String uri) {
        return this.allOutputDestinations == null || !this.allOutputDestinations.contains(uri);
    }

    public void checkImplicitResultTree() throws XPathException {
        if (!this.checkUniqueOutputDestination(Document.normalizeURI(this.principalResultURI))) {
            XPathException err = new XPathException("Cannot write an implicit result document if an explicit result document has been written to the same URI: " + this.principalResultURI);
            err.setErrorCode("XTDE1490");
            throw err;
        }
    }

    public void setThereHasBeenAnExplicitResultDocument() {
        this.thereHasBeenAnExplicitResultDocument = true;
    }

    public boolean hasThereBeenAnExplicitResultDocument() {
        return this.thereHasBeenAnExplicitResultDocument;
    }

    public SequenceOutputter allocateSequenceOutputter(int size) {
        if (this.reusableSequenceOutputter != null) {
            SequenceOutputter out = this.reusableSequenceOutputter;
            this.reusableSequenceOutputter = null;
            return out;
        }
        return new SequenceOutputter(this, size);
    }

    public void reuseSequenceOutputter(SequenceOutputter out) {
        this.reusableSequenceOutputter = out;
    }

    public void setInitialTemplate(String expandedName) throws XPathException {
        if (expandedName == null || expandedName.length() == 0) {
            this.initialTemplate = null;
            return;
        }
        StructuredQName qName = StructuredQName.fromClarkName(expandedName);
        Template t = this.getExecutable().getNamedTemplate(qName);
        if (t == null) {
            XPathException err = new XPathException("The requested initial template, with expanded name " + expandedName + ", does not exist");
            err.setErrorCode("XTDE0040");
            this.reportFatalError(err);
            throw err;
        }
        if (t.hasRequiredParams()) {
            XPathException err = new XPathException("The named template " + expandedName + " has required parameters, so cannot be used as the entry point");
            err.setErrorCode("XTDE0060");
            this.reportFatalError(err);
            throw err;
        }
        this.initialTemplate = t;
    }

    public String getInitialTemplate() {
        if (this.initialTemplate == null) {
            return null;
        }
        return this.initialTemplate.getTemplateName().getClarkName();
    }

    public PipelineConfiguration makePipelineConfiguration() {
        PipelineConfiguration pipe = new PipelineConfiguration();
        pipe.setConfiguration(this.getConfiguration());
        pipe.setURIResolver(this.userURIResolver == null ? this.standardURIResolver : this.userURIResolver);
        pipe.setSchemaURIResolver(this.schemaURIResolver);
        pipe.setExpandAttributeDefaults(this.getConfiguration().isExpandAttributeDefaults());
        pipe.setParseOptions(new ParseOptions(this.config.getParseOptions()));
        pipe.setErrorListener(this.getErrorListener());
        pipe.setController(this);
        Executable executable = this.getExecutable();
        if (executable != null) {
            pipe.setLocationProvider(executable.getLocationMap());
            pipe.setHostLanguage(executable.getHostLanguage());
        }
        return pipe;
    }

    private Receiver makeMessageReceiver() throws XPathException {
        Object messageReceiver = this.config.getInstance(this.messageReceiverClassName, this.getClassLoader());
        if (!(messageReceiver instanceof Receiver)) {
            throw new XPathException(String.valueOf(this.messageReceiverClassName) + " is not a Receiver");
        }
        this.setMessageEmitter((Receiver)messageReceiver);
        return (Receiver)messageReceiver;
    }

    public void setMessageEmitter(Receiver receiver) {
        this.messageReceiver = receiver;
        if (receiver.getPipelineConfiguration() == null) {
            this.messageReceiver.setPipelineConfiguration(this.makePipelineConfiguration());
        }
        if (this.messageReceiver instanceof Emitter && ((Emitter)this.messageReceiver).getOutputProperties() == null) {
            try {
                Properties props = new Properties();
                props.setProperty("method", "xml");
                props.setProperty("indent", "yes");
                props.setProperty("omit-xml-declaration", "yes");
                ((Emitter)this.messageReceiver).setOutputProperties(props);
            }
            catch (XPathException xPathException) {}
        }
    }

    public Receiver getMessageEmitter() {
        return this.messageReceiver;
    }

    public CharacterMapExpander makeCharacterMapExpander(String useMaps, SerializerFactory sf) throws XPathException {
        CharacterMapExpander characterMapExpander = null;
        HashMap<StructuredQName, IntHashMap<String>> characterMapIndex = this.getExecutable().getCharacterMapIndex();
        if (useMaps != null && characterMapIndex != null) {
            ArrayList<IntHashMap<String>> characterMaps = new ArrayList<IntHashMap<String>>(5);
            StringTokenizer st = new StringTokenizer(useMaps, " \t\n\r", false);
            while (st.hasMoreTokens()) {
                String expandedName = st.nextToken();
                StructuredQName qName = StructuredQName.fromClarkName(expandedName);
                IntHashMap<String> map = characterMapIndex.get(qName);
                if (map == null) {
                    throw new XPathException("Character map '" + expandedName + "' has not been defined");
                }
                characterMaps.add(map);
            }
            if (!characterMaps.isEmpty()) {
                characterMapExpander = sf.newCharacterMapExpander();
                characterMapExpander.setCharacterMaps(characterMaps);
            }
        }
        return characterMapExpander;
    }

    public void setRecoveryPolicy(int policy) {
        this.recoveryPolicy = policy;
        if (this.errorListener instanceof StandardErrorListener) {
            ((StandardErrorListener)this.errorListener).setRecoveryPolicy(policy);
        }
    }

    public int getRecoveryPolicy() {
        return this.recoveryPolicy;
    }

    @Override
    public void setErrorListener(ErrorListener listener) {
        this.errorListener = listener;
    }

    @Override
    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    public void recoverableError(XPathException err) throws XPathException {
        try {
            if (this.executable.getHostLanguage() == 51) {
                this.reportFatalError(err);
                throw err;
            }
            this.errorListener.error(err);
        }
        catch (TransformerException e) {
            XPathException de = XPathException.makeXPathException(e);
            de.setHasBeenReported(true);
            throw de;
        }
    }

    public void reportFatalError(XPathException err) {
        if (!err.hasBeenReported()) {
            try {
                this.getErrorListener().fatalError(err);
            }
            catch (TransformerException transformerException) {}
            err.setHasBeenReported(true);
        }
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public DocumentPool getDocumentPool() {
        return this.sourceDocumentPool;
    }

    public void clearDocumentPool() {
        this.sourceDocumentPool = new DocumentPool();
    }

    public void setInitialContextItem(Item item) {
        this.initialContextItem = item;
        this.contextForGlobalVariables = item;
    }

    public Bindery getBindery() {
        return this.bindery;
    }

    public Item getInitialContextItem() {
        return this.initialContextItem;
    }

    public Item getContextForGlobalVariables() {
        return this.contextForGlobalVariables;
    }

    @Override
    public void setURIResolver(URIResolver resolver) {
        this.userURIResolver = resolver;
        if (resolver instanceof StandardURIResolver) {
            ((StandardURIResolver)resolver).setConfiguration(this.getConfiguration());
        }
    }

    @Override
    public URIResolver getURIResolver() {
        return this.userURIResolver;
    }

    public URIResolver getStandardURIResolver() {
        return this.standardURIResolver;
    }

    public void setOutputURIResolver(OutputURIResolver resolver) {
        this.outputURIResolver = resolver == null ? this.config.getOutputURIResolver() : resolver;
    }

    public OutputURIResolver getOutputURIResolver() {
        return this.outputURIResolver;
    }

    public void setUnparsedTextURIResolver(UnparsedTextURIResolver resolver) {
        this.unparsedTextResolver = resolver;
    }

    public UnparsedTextURIResolver getUnparsedTextURIResolver() {
        return this.unparsedTextResolver;
    }

    public void setSchemaURIResolver(SchemaURIResolver resolver) {
        this.schemaURIResolver = resolver;
    }

    public SchemaURIResolver getSchemaURIResolver() {
        return this.schemaURIResolver;
    }

    public int getSchemaValidationMode() {
        return this.validationMode;
    }

    public void setSchemaValidationMode(int validationMode) {
        this.validationMode = validationMode;
    }

    public KeyManager getKeyManager() {
        return this.executable.getKeyManager();
    }

    public NamePool getNamePool() {
        return this.namePool;
    }

    public void setTreeModel(int model) {
        this.treeModel = TreeModel.getTreeModel(model);
    }

    public int getTreeModel() {
        return this.treeModel.getSymbolicValue();
    }

    public void setModel(TreeModel model) {
        this.treeModel = model;
    }

    public TreeModel getModel() {
        return this.treeModel;
    }

    public Builder makeBuilder() {
        Builder b = this.treeModel.makeBuilder();
        b.setTiming(this.config.isTiming());
        b.setLineNumbering(this.config.isLineNumbering());
        b.setPipelineConfiguration(this.makePipelineConfiguration());
        return b;
    }

    public Stripper makeStripper(Receiver b) {
        if (this.config.isStripsAllWhiteSpace()) {
            if (b == null) {
                return AllElementStripper.getInstance();
            }
            AllElementStripper s = new AllElementStripper();
            s.setUnderlyingReceiver(b);
            s.setPipelineConfiguration(b.getPipelineConfiguration());
            return s;
        }
        Stripper stripper = this.executable == null ? new Stripper(new Mode(-4, Mode.DEFAULT_MODE_NAME)) : this.executable.newStripper();
        stripper.setXPathContext(this.newXPathContext());
        if (b == null) {
            stripper.setPipelineConfiguration(this.makePipelineConfiguration());
        } else {
            stripper.setPipelineConfiguration(b.getPipelineConfiguration());
            stripper.setUnderlyingReceiver(b);
        }
        return stripper;
    }

    public void registerDocument(DocumentInfo doc, String systemId) throws XPathException {
        if (doc != null) {
            if (!this.getExecutable().isSchemaAware() && doc.getTypeAnnotation() != 630) {
                String task = this.getExecutable().getHostLanguage() == 50 ? "transformation" : "query";
                throw new XPathException("The " + task + " is not schema-aware, so the source document must be untyped");
            }
            this.sourceDocumentPool.add(doc, systemId);
        }
    }

    public void setRuleManager(RuleManager r) {
        this.ruleManager = r;
    }

    public RuleManager getRuleManager() {
        return this.ruleManager;
    }

    public void setTraceListener(TraceListener listener) {
        this.traceListener = listener;
    }

    public TraceListener getTraceListener() {
        return this.traceListener;
    }

    public final boolean isTracing() {
        return this.traceListener != null && !this.tracingPaused;
    }

    public final void pauseTracing(boolean pause) {
        this.tracingPaused = pause;
    }

    public void addTraceListener(TraceListener trace) {
        if (trace != null) {
            this.traceListener = TraceEventMulticaster.add(this.traceListener, trace);
        }
    }

    public void removeTraceListener(TraceListener trace) {
        this.traceListener = TraceEventMulticaster.remove(this.traceListener, trace);
    }

    public void setTraceFunctionDestination(PrintStream stream) {
        this.traceFunctionDestination = stream;
    }

    public PrintStream getTraceFunctionDestination() {
        return this.traceFunctionDestination;
    }

    public void setPreparedStylesheet(PreparedStylesheet sheet) {
        this.preparedStylesheet = sheet;
        this.executable = sheet.getExecutable();
        this.messageReceiverClassName = sheet.getCompilerInfo().getMessageReceiverClassName();
        this.outputURIResolver = sheet.getCompilerInfo().getOutputURIResolver();
    }

    public void setExecutable(Executable exec) {
        this.executable = exec;
    }

    public void initializeController() throws XPathException {
        this.setRuleManager(this.executable.getRuleManager());
        if (this.traceListener != null) {
            this.traceListener.open();
        }
        this.bindery = new Bindery();
        this.executable.initializeBindery(this.bindery);
        this.defineGlobalParameters();
    }

    public void defineGlobalParameters() throws XPathException {
        this.executable.checkAllRequiredParamsArePresent(this.parameters);
        this.bindery.defineGlobalParameters(this.parameters);
    }

    public void allocateGlobalVariables(int numberOfVariables) {
        SlotManager map = this.executable.getGlobalVariableMap();
        map.setNumberOfVariables(numberOfVariables);
        this.bindery.allocateGlobals(map);
    }

    public Object getUserData(Object key, String name) {
        String keyValue = String.valueOf(key.hashCode()) + " " + name;
        return this.userDataTable.get(keyValue);
    }

    public void setUserData(Object key, String name, Object data) {
        String keyVal = String.valueOf(key.hashCode()) + " " + name;
        if (data == null) {
            this.userDataTable.remove(keyVal);
        } else {
            this.userDataTable.put(keyVal, data);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void transform(Source source, Result result) throws TransformerException {
        this.clearPerTransformationData();
        if (this.preparedStylesheet == null) {
            throw new XPathException("Stylesheet has not been prepared");
        }
        if (!this.dateTimePreset) {
            this.currentDateTime = null;
        }
        boolean close = false;
        try {
            try {
                Source s2;
                NodeInfo startNode = null;
                boolean wrap = true;
                boolean streaming = false;
                int validationMode = this.getSchemaValidationMode();
                Source underSource = source;
                if (source instanceof AugmentedSource) {
                    Boolean localWrap = ((AugmentedSource)source).getWrapDocument();
                    if (localWrap != null) {
                        wrap = localWrap;
                    }
                    close = ((AugmentedSource)source).isPleaseCloseAfterUse();
                    int localValidate = ((AugmentedSource)source).getSchemaValidation();
                    if (localValidate != 0) {
                        validationMode = localValidate;
                    }
                    if (validationMode == 1 || validationMode == 2) {
                        wrap = false;
                    }
                    underSource = ((AugmentedSource)source).getContainedSource();
                }
                if ((s2 = this.config.getSourceResolver().resolveSource(underSource, this.config)) != null) {
                    underSource = s2;
                }
                if (wrap && (underSource instanceof NodeInfo || underSource instanceof DOMSource)) {
                    startNode = this.prepareInputTree(underSource);
                    this.registerDocument(startNode.getDocumentRoot(), underSource.getSystemId());
                } else if (source == null) {
                    if (this.initialTemplate == null) {
                        throw new XPathException("Either a source document or an initial template must be specified");
                    }
                } else {
                    Mode mode = this.executable.getRuleManager().getMode(this.initialMode, false);
                    if (mode == null || this.initialMode != null && mode.isEmpty()) {
                        throw new XPathException("Requested initial mode " + (this.initialMode == null ? "" : this.initialMode.getDisplayName()) + " does not exist", "XTDE0045");
                    }
                    if (mode.isStreamable()) {
                        if (!(source instanceof StreamSource) && !(source instanceof SAXSource)) throw new XPathException("Requested initial mode " + (this.initialMode == null ? "" : this.initialMode.getDisplayName()) + " is streamable: must supply a SAXSource or StreamSource", "SXST0061");
                        streaming = true;
                        this.transformStream(source, mode, result);
                    } else {
                        void var13_23;
                        Builder sourceBuilder = this.makeBuilder();
                        Sender sender = new Sender(sourceBuilder.getPipelineConfiguration());
                        Builder builder = sourceBuilder;
                        if (this.config.isStripsAllWhiteSpace() || this.executable.stripsWhitespace() || validationMode == 1 || validationMode == 2) {
                            Stripper stripper = this.makeStripper(sourceBuilder);
                        }
                        if (this.executable.stripsInputTypeAnnotations()) {
                            void var13_21;
                            Receiver receiver = this.config.getAnnotationStripper((Receiver)var13_21);
                        }
                        sender.send(source, (Receiver)var13_23, sourceBuilder.getPipelineConfiguration().getParseOptions());
                        if (close) {
                            ((AugmentedSource)source).close();
                        }
                        DocumentInfo doc = (DocumentInfo)sourceBuilder.getCurrentRoot();
                        sourceBuilder.reset();
                        this.registerDocument(doc, source.getSystemId());
                        startNode = doc;
                    }
                }
                if (streaming) return;
                this.transformDocument(startNode, result);
                return;
            }
            catch (TerminationException err) {
                throw err;
            }
            catch (XPathException err) {
                Throwable cause = err.getException();
                if (cause != null && cause instanceof SAXParseException) {
                    SAXParseException spe = (SAXParseException)cause;
                    if (!((cause = spe.getException()) instanceof RuntimeException)) throw err;
                    this.reportFatalError(err);
                    throw err;
                } else {
                    this.reportFatalError(err);
                }
                throw err;
            }
            catch (NullPointerException err) {
                err.printStackTrace();
                throw err;
            }
        }
        finally {
            if (close) {
                ((AugmentedSource)source).close();
            }
            this.principalResultURI = null;
        }
    }

    public NodeInfo prepareInputTree(Source source) {
        VirtualNode strippedDoc;
        DocumentInfo docInfo;
        NodeInfo start = this.getConfiguration().unravel(source);
        if (this.executable.stripsWhitespace()) {
            docInfo = start.getDocumentRoot();
            strippedDoc = new SpaceStrippedDocument(docInfo, this.makeStripper(null));
            start = ((SpaceStrippedDocument)strippedDoc).wrap(start);
        }
        if (this.executable.stripsInputTypeAnnotations() && (docInfo = start.getDocumentRoot()).getTypeAnnotation() != 630) {
            strippedDoc = new TypeStrippedDocument(docInfo);
            start = ((TypeStrippedDocument)strippedDoc).wrap(start);
        }
        return start;
    }

    public void transformDocument(NodeInfo startNode, Result result) throws TransformerException {
        if (this.executable == null) {
            throw new XPathException("Stylesheet has not been compiled");
        }
        this.openMessageEmitter();
        boolean mustClose = result instanceof StreamResult && ((StreamResult)result).getOutputStream() == null;
        this.principalResult = result;
        if (this.principalResultURI == null) {
            this.principalResultURI = result.getSystemId();
        }
        XPathContextMajor initialContext = this.newXPathContext();
        initialContext.setOriginatingConstructType(2000);
        if (startNode != null) {
            this.initialContextItem = startNode;
            this.contextForGlobalVariables = startNode.getRoot();
            if (startNode.getConfiguration() == null) {
                throw new TransformerException("The supplied source document must be associated with a Configuration");
            }
            if (!startNode.getConfiguration().isCompatible(this.preparedStylesheet.getConfiguration())) {
                throw new XPathException("Source document and stylesheet must use the same or compatible Configurations", "SXXP0004");
            }
            UnfailingIterator currentIter = SingletonIterator.makeIterator(startNode);
            if (this.initialTemplate != null) {
                currentIter.next();
            }
            initialContext.setCurrentIterator(currentIter);
        }
        this.initializeController();
        if (this.traceListener != null) {
            this.preEvaluateGlobals(initialContext);
        }
        result = this.openResult(result, initialContext);
        if (this.initialTemplate == null) {
            this.initialContextItem = startNode;
            Mode mode = this.getRuleManager().getMode(this.initialMode, false);
            if (mode == null || this.initialMode != null && mode.isEmpty()) {
                throw new XPathException("Requested initial mode " + (this.initialMode == null ? "" : this.initialMode.getDisplayName()) + " does not exist", "XTDE0045");
            }
            if (mode.isStreamable()) {
                throw new XPathException("Requested initial mode " + (this.initialMode == null ? "" : this.initialMode.getDisplayName()) + " is streamable: must supply a StreamSource or SAXSource");
            }
            TailCall tc = ApplyTemplates.applyTemplates(initialContext.getCurrentIterator(), mode, null, null, initialContext, 0);
            while (tc != null) {
                tc = tc.processLeavingTail();
            }
        } else {
            Template t = this.initialTemplate;
            XPathContextMajor c2 = initialContext.newContext();
            initialContext.setOriginatingConstructType(2000);
            c2.openStackFrame(t.getStackFrameMap());
            c2.setLocalParameters(new ParameterSet());
            c2.setTunnelParameters(new ParameterSet());
            TailCall tc = t.expand(c2);
            while (tc != null) {
                tc = tc.processLeavingTail();
            }
        }
        if (this.traceListener != null) {
            this.traceListener.close();
        }
        this.closeMessageEmitter();
        this.closeResult(result, mustClose, initialContext);
    }

    public void transformStream(Source source, Mode mode, Result result) throws TransformerException {
        if (this.executable == null) {
            throw new XPathException("Stylesheet has not been compiled");
        }
        this.openMessageEmitter();
        boolean mustClose = result instanceof StreamResult && ((StreamResult)result).getOutputStream() == null;
        this.principalResult = result;
        if (this.principalResultURI == null) {
            this.principalResultURI = result.getSystemId();
        }
        XPathContextMajor initialContext = this.newXPathContext();
        initialContext.setOriginatingConstructType(2000);
        this.initialContextItem = null;
        this.contextForGlobalVariables = null;
        this.initializeController();
        result = this.openResult(result, initialContext);
        if (!mode.isStreamable()) {
            throw new XPathException("mode supplied to transformStream() must be streamable");
        }
        Receiver despatcher = this.config.makeStreamingTransformer(initialContext, mode);
        if (despatcher == null) {
            throw new TransformerException("Streaming requires Saxon-EE");
        }
        if (this.config.isStripsAllWhiteSpace() || this.executable.stripsWhitespace()) {
            despatcher = this.makeStripper(despatcher);
        }
        PipelineConfiguration pipe = despatcher.getPipelineConfiguration();
        Sender sender = new Sender(pipe);
        sender.send(source, despatcher, pipe.getParseOptions());
        if (this.traceListener != null) {
            this.traceListener.close();
        }
        this.closeResult(result, mustClose, initialContext);
        this.closeMessageEmitter();
    }

    private void closeMessageEmitter() throws XPathException {
        this.getMessageEmitter().close();
    }

    private void closeResult(Result result, boolean mustClose, XPathContextMajor initialContext) throws XPathException {
        OutputStream os;
        SequenceReceiver out = initialContext.getReceiver();
        if (out instanceof ComplexContentOutputter && ((ComplexContentOutputter)out).contentHasBeenWritten() && this.principalResultURI != null) {
            String documentKey = Document.normalizeURI(this.principalResultURI);
            if (!this.checkUniqueOutputDestination(documentKey)) {
                XPathException err = new XPathException("Cannot write more than one result document to the same URI, or write to a URI that has been read: " + result.getSystemId());
                err.setErrorCode("XTDE1490");
                throw err;
            }
            this.addUnavailableOutputDestination(documentKey);
        }
        out.endDocument();
        out.close();
        if (mustClose && result instanceof StreamResult && (os = ((StreamResult)result).getOutputStream()) != null) {
            try {
                os.close();
            }
            catch (IOException err) {
                throw new XPathException(err);
            }
        }
    }

    private Result openResult(Result result, XPathContextMajor initialContext) throws TransformerException {
        Properties xslOutputProps = this.localOutputProperties == null ? this.executable.getDefaultOutputProperties() : this.localOutputProperties;
        String nextInChain = xslOutputProps.getProperty("{http://saxon.sf.net/}next-in-chain");
        if (nextInChain != null && nextInChain.length() > 0) {
            String baseURI = xslOutputProps.getProperty("{http://saxon.sf.net/}next-in-chain-base-uri");
            result = this.prepareNextStylesheet(nextInChain, baseURI, result);
        }
        SerializerFactory sf = this.getConfiguration().getSerializerFactory();
        PipelineConfiguration pipe = this.makePipelineConfiguration();
        pipe.setHostLanguage(50);
        Receiver receiver = sf.getReceiver(result, pipe, xslOutputProps);
        boolean openNow = false;
        if (this.getExecutable().createsSecondaryResult()) {
            receiver = new ImplicitResultChecker(receiver, this);
            receiver.setPipelineConfiguration(pipe);
        } else {
            openNow = true;
        }
        initialContext.changeOutputDestination(receiver, true, 3, null);
        if (openNow) {
            SequenceReceiver out = initialContext.getReceiver();
            out.open();
            out.startDocument(0);
        }
        return result;
    }

    private void openMessageEmitter() throws XPathException {
        if (this.getMessageEmitter() == null) {
            Receiver me = this.makeMessageReceiver();
            this.setMessageEmitter(me);
            if (me instanceof Emitter && ((Emitter)me).getWriter() == null) {
                try {
                    ((Emitter)me).setWriter(new OutputStreamWriter(System.err));
                }
                catch (Exception exception) {
                    try {
                        ((Emitter)me).setWriter(new OutputStreamWriter((OutputStream)System.err, "utf8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new XPathException(e);
                    }
                }
            }
        }
        this.getMessageEmitter().open();
    }

    public void preEvaluateGlobals(XPathContext context) throws XPathException {
        HashMap<StructuredQName, GlobalVariable> vars = this.getExecutable().getCompiledGlobalVariables();
        if (vars != null) {
            for (GlobalVariable var : vars.values()) {
                var.evaluateVariable(context);
            }
        }
    }

    public Result prepareNextStylesheet(String href, String baseURI, Result result) throws TransformerException {
        PreparedStylesheet next = this.preparedStylesheet.getCachedStylesheet(href, baseURI);
        if (next == null) {
            Source source = null;
            if (this.userURIResolver != null) {
                source = this.userURIResolver.resolve(href, baseURI);
            }
            if (source == null) {
                source = this.standardURIResolver.resolve(href, baseURI);
            }
            TransformerFactoryImpl factory = new TransformerFactoryImpl();
            factory.setConfiguration(this.config);
            next = (PreparedStylesheet)factory.newTemplates(source);
            this.preparedStylesheet.putCachedStylesheet(href, baseURI, next);
        }
        TransformerReceiver nextTransformer = new TransformerReceiver((Controller)next.newTransformer());
        nextTransformer.setSystemId(this.principalResultURI);
        nextTransformer.setPipelineConfiguration(this.makePipelineConfiguration());
        nextTransformer.setResult(result);
        nextTransformer.open();
        return nextTransformer;
    }

    @Override
    public void setParameter(String expandedName, Object value) {
        if (this.parameters == null) {
            this.parameters = new GlobalParameterSet();
        }
        this.parameters.put(StructuredQName.fromClarkName(expandedName), value);
    }

    public void setParameter(StructuredQName qName, ValueRepresentation value) {
        if (this.parameters == null) {
            this.parameters = new GlobalParameterSet();
        }
        this.parameters.put(qName, value);
    }

    @Override
    public void clearParameters() {
        this.parameters = null;
    }

    @Override
    public Object getParameter(String expandedName) {
        if (this.parameters == null) {
            return null;
        }
        return this.parameters.get(StructuredQName.fromClarkName(expandedName));
    }

    public Iterator iterateParameters() {
        if (this.parameters == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        int k = this.parameters.getNumberOfKeys();
        ArrayList<String> list = new ArrayList<String>(k);
        Collection<StructuredQName> keys = this.parameters.getKeys();
        for (StructuredQName qName : keys) {
            String clarkName = qName.getClarkName();
            list.add(clarkName);
        }
        return list.iterator();
    }

    public void setCurrentDateTime(DateTimeValue dateTime) throws XPathException {
        if (this.currentDateTime == null) {
            if (dateTime.getComponent(7) == null) {
                throw new XPathException("No timezone is present in supplied value of current date/time");
            }
        } else {
            throw new IllegalStateException("Current date and time can only be set once, and cannot subsequently be changed");
        }
        this.currentDateTime = dateTime;
        this.dateTimePreset = true;
    }

    public DateTimeValue getCurrentDateTime() {
        if (this.currentDateTime == null) {
            this.currentDateTime = new DateTimeValue(new GregorianCalendar(), true);
        }
        return this.currentDateTime;
    }

    public int getImplicitTimezone() {
        return this.getCurrentDateTime().getTimezoneInMinutes();
    }

    public XPathContextMajor newXPathContext() {
        return new XPathContextMajor(this);
    }

    public void setRememberedNumber(NodeInfo node, int number) {
        this.lastRememberedNode = node;
        this.lastRememberedNumber = number;
    }

    public int getRememberedNumber(NodeInfo node) {
        if (this.lastRememberedNode == node) {
            return this.lastRememberedNumber;
        }
        return -1;
    }

    public void setUseDocumentProjection(PathMap pathMap) {
        this.pathMap = pathMap;
    }

    public PathMap getPathMapForDocumentProjection() {
        return this.pathMap;
    }

    public void setClassLoader(ClassLoader loader) {
        this.classLoader = loader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

