/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.Sink;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Whitespace;

public class TracingFilter
extends ProxyReceiver {
    private static int nextid = 0;
    private int id = nextid++;
    private String indent = "";

    public TracingFilter() {
    }

    public TracingFilter(Receiver r) {
        this.setUnderlyingReceiver(r);
    }

    @Override
    public void append(Item item, int locationId, int copyNamespaces) throws XPathException {
        System.err.println("RCVR " + this.id + this.indent + " APPEND " + item.getClass().getName());
        if (this.nextReceiver instanceof SequenceReceiver) {
            ((SequenceReceiver)this.nextReceiver).append(item, locationId, copyNamespaces);
        } else {
            super.append(item, locationId, copyNamespaces);
        }
    }

    @Override
    public void attribute(int nameCode, int typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        System.err.println("RCVR " + this.id + this.indent + " ATTRIBUTE " + this.getNamePool().getDisplayName(nameCode));
        this.nextReceiver.attribute(nameCode, typeCode, value, locationId, properties);
    }

    @Override
    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        System.err.println("RCVR " + this.id + this.indent + " CHARACTERS " + (Whitespace.isWhite(chars) ? "(whitespace)" : ""));
        FastStringBuffer sb = new FastStringBuffer(chars.length() * 3);
        int i = 0;
        while (i < chars.length()) {
            sb.append(String.valueOf((int)chars.charAt(i)) + " ");
            ++i;
        }
        System.err.println("    \"" + sb + '\"');
        this.nextReceiver.characters(chars, locationId, properties);
    }

    @Override
    public void close() throws XPathException {
        System.err.println("RCVR " + this.id + this.indent + " CLOSE");
        this.nextReceiver.close();
    }

    @Override
    public void comment(CharSequence chars, int locationId, int properties) throws XPathException {
        System.err.println("RCVR " + this.id + this.indent + " COMMENT");
        this.nextReceiver.comment(chars, locationId, properties);
    }

    @Override
    public void endDocument() throws XPathException {
        System.err.println("RCVR " + this.id + this.indent + " END DOCUMENT");
        this.nextReceiver.endDocument();
    }

    @Override
    public void endElement() throws XPathException {
        this.indent = this.indent.substring(2);
        System.err.println("RCVR " + this.id + this.indent + " END ELEMENT");
        this.nextReceiver.endElement();
    }

    @Override
    public void namespace(int namespaceCode, int properties) throws XPathException {
        System.err.println("RCVR " + this.id + this.indent + " NAMESPACE " + this.getNamePool().getPrefixFromNamespaceCode(namespaceCode) + "=" + this.getNamePool().getURIFromNamespaceCode(namespaceCode));
        this.nextReceiver.namespace(namespaceCode, properties);
    }

    @Override
    public void open() throws XPathException {
        System.err.println("RCVR " + this.id + this.indent + " OPEN");
        if (this.nextReceiver == null) {
            this.nextReceiver = new Sink();
        }
        this.nextReceiver.open();
    }

    @Override
    public void processingInstruction(String target, CharSequence data, int locationId, int properties) throws XPathException {
        System.err.println("RCVR " + this.id + this.indent + " PROCESSING INSTRUCTION");
        this.nextReceiver.processingInstruction(target, data, locationId, properties);
    }

    @Override
    public void startContent() throws XPathException {
        System.err.println("RCVR " + this.id + this.indent + " START CONTENT");
        this.nextReceiver.startContent();
    }

    @Override
    public void startDocument(int properties) throws XPathException {
        System.err.println("RCVR " + this.id + this.indent + " START DOCUMENT");
        this.nextReceiver.startDocument(properties);
    }

    @Override
    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        System.err.println("RCVR " + this.id + this.indent + " START ELEMENT " + this.getNamePool().getDisplayName(nameCode));
        this.indent = String.valueOf(this.indent) + "  ";
        this.nextReceiver.startElement(nameCode, typeCode, locationId, properties);
    }
}

