/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.HashSet;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.om.Item;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Value;

public class TypeCheckingFilter
extends ProxyReceiver {
    private ItemType itemType;
    private int cardinality;
    private RoleLocator role;
    private SourceLocator locator;
    private int count = 0;
    private int level = 0;
    private HashSet checkedElements = new HashSet(10);

    public void setRequiredType(ItemType type, int cardinality, RoleLocator role, SourceLocator locator) {
        this.itemType = type;
        this.cardinality = cardinality;
        this.role = role;
        this.locator = locator;
    }

    @Override
    public void attribute(int nameCode, int typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        if (this.level == 0) {
            if (++this.count == 2) {
                this.checkAllowsMany(locationId);
            }
            CombinedNodeTest type = new CombinedNodeTest(new NameTest(2, nameCode, this.getNamePool()), 23, new ContentTypeTest(2, this.getConfiguration().getSchemaType(typeCode), this.getConfiguration()));
            this.checkItemType(type, locationId);
        }
        this.nextReceiver.attribute(nameCode, typeCode, value, locationId, properties);
    }

    @Override
    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        if (this.level == 0) {
            if (++this.count == 2) {
                this.checkAllowsMany(locationId);
            }
            NodeKindTest type = NodeKindTest.TEXT;
            this.checkItemType(type, locationId);
        }
        this.nextReceiver.characters(chars, locationId, properties);
    }

    @Override
    public void comment(CharSequence chars, int locationId, int properties) throws XPathException {
        if (this.level == 0) {
            if (++this.count == 2) {
                this.checkAllowsMany(locationId);
            }
            NodeKindTest type = NodeKindTest.COMMENT;
            this.checkItemType(type, locationId);
        }
        this.nextReceiver.comment(chars, locationId, properties);
    }

    @Override
    public void namespace(int namespaceCode, int properties) throws XPathException {
        if (this.level == 0) {
            if (++this.count == 2) {
                this.checkAllowsMany(0L);
            }
            NodeKindTest type = NodeKindTest.NAMESPACE;
            this.checkItemType(type, 0L);
        }
        this.nextReceiver.namespace(namespaceCode, properties);
    }

    @Override
    public void processingInstruction(String target, CharSequence data, int locationId, int properties) throws XPathException {
        if (this.level == 0) {
            if (++this.count == 2) {
                this.checkAllowsMany(locationId);
            }
            NodeKindTest type = NodeKindTest.PROCESSING_INSTRUCTION;
            this.checkItemType(type, locationId);
        }
        this.nextReceiver.processingInstruction(target, data, locationId, properties);
    }

    @Override
    public void startDocument(int properties) throws XPathException {
        if (this.level == 0) {
            if (++this.count == 2) {
                this.checkAllowsMany(0L);
            }
            NodeKindTest type = NodeKindTest.DOCUMENT;
            this.checkItemType(type, 0L);
        }
        ++this.level;
        this.nextReceiver.startDocument(properties);
    }

    @Override
    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        if (this.level == 0) {
            if (++this.count == 1) {
                CombinedNodeTest type = new CombinedNodeTest(new NameTest(1, nameCode, this.getNamePool()), 23, new ContentTypeTest(1, this.getConfiguration().getSchemaType(typeCode), this.getConfiguration()));
                this.checkItemType(type, locationId);
            } else {
                Long key;
                if (this.count == 2) {
                    this.checkAllowsMany(locationId);
                }
                if (!this.checkedElements.contains(key = new Long((long)(nameCode & 0xFFFFF) << 32 | (long)(typeCode & 0xFFFFF)))) {
                    CombinedNodeTest type = new CombinedNodeTest(new NameTest(1, nameCode, this.getNamePool()), 23, new ContentTypeTest(1, this.getConfiguration().getSchemaType(typeCode), this.getConfiguration()));
                    this.checkItemType(type, locationId);
                    this.checkedElements.add(key);
                }
            }
        }
        ++this.level;
        this.nextReceiver.startElement(nameCode, typeCode, locationId, properties);
    }

    @Override
    public void endDocument() throws XPathException {
        --this.level;
        this.nextReceiver.endDocument();
    }

    @Override
    public void endElement() throws XPathException {
        --this.level;
        this.nextReceiver.endElement();
    }

    @Override
    public void close() throws XPathException {
        if (this.count == 0 && !Cardinality.allowsZero(this.cardinality)) {
            XPathException err = new XPathException("An empty sequence is not allowed as the " + this.role.getMessage());
            String errorCode = this.role.getErrorCode();
            err.setErrorCode(errorCode);
            if (!"XPDY0050".equals(errorCode)) {
                err.setIsTypeError(true);
            }
            throw err;
        }
    }

    @Override
    public void append(Item item, int locationId, int copyNamespaces) throws XPathException {
        if (this.level == 0) {
            if (++this.count == 2) {
                this.checkAllowsMany(locationId);
            }
            this.checkItemType(Value.asValue(item).getItemType(this.getConfiguration().getTypeHierarchy()), locationId);
        }
        if (this.nextReceiver instanceof SequenceReceiver) {
            ((SequenceReceiver)this.nextReceiver).append(item, locationId, copyNamespaces);
        } else {
            super.append(item, locationId, copyNamespaces);
        }
    }

    @Override
    public boolean usesTypeAnnotations() {
        return true;
    }

    private void checkItemType(ItemType type, long locationId) throws XPathException {
        if (!this.getConfiguration().getTypeHierarchy().isSubType(type, this.itemType)) {
            String message = this.role.composeErrorMessage(this.itemType, type, this.getNamePool());
            String errorCode = this.role.getErrorCode();
            XPathException err = new XPathException(message);
            err.setErrorCode(errorCode);
            if (!"XPDY0050".equals(errorCode)) {
                err.setIsTypeError(true);
            }
            if (locationId == 0L) {
                err.setLocator(this.locator);
            } else {
                err.setLocator(ExpressionLocation.getSourceLocator(locationId, this.getPipelineConfiguration().getLocationProvider()));
            }
            throw err;
        }
    }

    private void checkAllowsMany(long locationId) throws XPathException {
        if (!Cardinality.allowsMany(this.cardinality)) {
            XPathException err = new XPathException("A sequence of more than one item is not allowed as the " + this.role.getMessage());
            String errorCode = this.role.getErrorCode();
            err.setErrorCode(errorCode);
            if (!"XPDY0050".equals(errorCode)) {
                err.setIsTypeError(true);
            }
            if (locationId == 0L) {
                err.setLocator(this.locator);
            } else {
                err.setLocator(ExpressionLocation.getSourceLocator(locationId, this.getPipelineConfiguration().getLocationProvider()));
            }
            throw err;
        }
    }
}

