/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.FirstItemExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.ParentNodeExpression;
import net.sf.saxon.expr.PathExpression;
import net.sf.saxon.expr.PathMap;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Axis;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.DocumentNodeTest;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.sort.IntHashSet;
import net.sf.saxon.sort.IntIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;

public final class AxisExpression
extends Expression {
    private byte axis;
    private NodeTest test;
    private ItemType itemType = null;
    private ItemType contextItemType = null;
    int computedCardinality = -1;
    private boolean doneWarnings = false;

    public AxisExpression(byte axis, NodeTest nodeTest) {
        this.axis = axis;
        this.test = nodeTest;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) {
        if (this.axis == 9 && (this.test == null || this.test instanceof AnyNodeTest)) {
            ParentNodeExpression p = new ParentNodeExpression();
            ExpressionTool.copyLocationInfo(this, p);
            return p;
        }
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        block47: {
            block48: {
                block46: {
                    block50: {
                        block49: {
                            config = visitor.getConfiguration();
                            namePool = config.getNamePool();
                            env = visitor.getStaticContext();
                            if (contextItemType == null) {
                                err = new XPathException("Axis step " + this.toString(namePool) + " cannot be used here: the context item is undefined");
                                err.setIsTypeError(true);
                                err.setErrorCode("XPDY0002");
                                err.setLocator(this);
                                throw err;
                            }
                            if (contextItemType.isAtomicType()) {
                                err = new XPathException("Axis step " + this.toString(namePool) + " cannot be used here: the context item is an atomic value");
                                err.setIsTypeError(true);
                                err.setErrorCode("XPTY0020");
                                err.setLocator(this);
                                throw err;
                            }
                            if (this.contextItemType == contextItemType && this.doneWarnings) {
                                return this;
                            }
                            this.contextItemType = contextItemType;
                            this.doneWarnings = true;
                            if (!(contextItemType instanceof NodeTest)) break block47;
                            origin = contextItemType.getPrimitiveType();
                            if (origin != 0 && Axis.isAlwaysEmpty(this.axis, origin)) {
                                env.issueWarning("The " + Axis.axisName[this.axis] + " axis starting at " + (origin == 1 || origin == 2 ? "an " : "a ") + NodeKindTest.nodeKindName(origin) + " node will never select anything", this);
                                return Literal.makeEmptySequence();
                            }
                            if (this.test == null) break block47;
                            kind = this.test.getPrimitiveType();
                            if (kind != 0 && !Axis.containsNodeKind(this.axis, kind)) {
                                env.issueWarning("The " + Axis.axisName[this.axis] + " axis will never select any " + NodeKindTest.nodeKindName(kind) + " nodes", this);
                                return Literal.makeEmptySequence();
                            }
                            if (this.axis == 12 && kind != 0 && origin != 0 && kind != origin) {
                                env.issueWarning("The self axis will never select any " + NodeKindTest.nodeKindName(kind) + " nodes when starting at " + (origin == 1 || origin == 2 ? "an " : "a ") + NodeKindTest.nodeKindName(origin) + " node", this);
                                return Literal.makeEmptySequence();
                            }
                            if (this.axis == 12) {
                                this.itemType = new CombinedNodeTest((NodeTest)contextItemType, 23, this.test);
                            }
                            if (contextItemType instanceof DocumentNodeTest && this.axis == 3 && kind == 1) {
                                elementTest = ((DocumentNodeTest)contextItemType).getElementTest();
                                requiredNames = elementTest.getRequiredNodeNames();
                                if (requiredNames != null && (selected = this.test.getRequiredNodeNames()) != null && selected.intersect(requiredNames).isEmpty()) {
                                    env.issueWarning("Starting at a document node, the step is selecting an element whose name is not among the names of child elements permitted for this document node type", this);
                                    return Literal.makeEmptySequence();
                                }
                                this.itemType = elementTest;
                                return this;
                            }
                            contentType = ((NodeTest)contextItemType).getContentType();
                            if (contentType == AnyType.getInstance()) {
                                return this;
                            }
                            targetfp = this.test.getFingerprint();
                            if (!contentType.isSimpleType()) break block48;
                            if (this.axis != 3 && this.axis != 4 && this.axis != 5 || kind != 1 && kind != 2 && kind != 9) break block49;
                            env.issueWarning("The " + Axis.axisName[this.axis] + " axis will never select any " + NodeKindTest.nodeKindName(kind) + " nodes when starting at a node with simple type " + contentType.getDescription(), this);
                            break block47;
                        }
                        if (this.axis != 3 || kind != 3 || !(visitor.getParentExpression() instanceof Atomizer)) break block50;
                        env.issueWarning("Selecting the text nodes of an element with simple content may give the wrong answer in the presence of comments or processing instructions. It is usually better to omit the '/text()' step", this);
                        break block47;
                    }
                    if (this.axis != 2) break block47;
                    extensions = config.getExtensionsOfType(contentType);
                    found = false;
                    if (targetfp != -1) ** GOTO lbl72
                    while (extensions.hasNext()) {
                        extension = (ComplexType)extensions.next();
                        if (!extension.allowsAttributes()) continue;
                        found = true;
                        break block46;
                    }
                    break block46;
lbl-1000:
                    // 1 sources

                    {
                        extension = (ComplexType)extensions.next();
                        try {
                            if (extension.getAttributeUseType(targetfp) == null) continue;
                            found = true;
                            break;
                        }
                        catch (SchemaException v0) {}
lbl72:
                        // 3 sources

                        ** while (extensions.hasNext())
                    }
                }
                if (!found) {
                    env.issueWarning("The " + Axis.axisName[this.axis] + " axis will never select " + (targetfp == -1 ? "any attribute nodes" : "an attribute node named " + env.getNamePool().getDisplayName(targetfp)) + " when starting at a node with simple type " + contentType.getDescription(), this);
                }
                break block47;
            }
            if (!(!((ComplexType)contentType).isSimpleContent() || this.axis != 3 && this.axis != 4 && this.axis != 5 || kind != 1 && kind != 9)) {
                env.issueWarning("The " + Axis.axisName[this.axis] + " axis will never select any " + NodeKindTest.nodeKindName(kind) + " nodes when starting at a node with type " + contentType.getDescription() + ", as this type requires simple content", this);
                return new Literal(EmptySequence.getInstance());
            }
            if (((ComplexType)contentType).isEmptyContent() && (this.axis == 3 || this.axis == 4 || this.axis == 5)) {
                iter = config.getExtensionsOfType(contentType);
                while (iter.hasNext()) {
                    extension = (ComplexType)iter.next();
                    if (extension.isEmptyContent()) continue;
                    return this;
                }
                env.issueWarning("The " + Axis.axisName[this.axis] + " axis will never select any" + " nodes when starting at a node with type " + contentType.getDescription() + ", as this type requires empty content", this);
                return new Literal(EmptySequence.getInstance());
            }
            if (this.axis == 2 && targetfp != -1) {
                try {
                    schemaType = ((ComplexType)contentType).getAttributeUseType(targetfp);
                    if (schemaType == null) {
                        n = env.getNamePool().getDisplayName(targetfp);
                        env.issueWarning("The complex type " + contentType.getDescription() + " does not allow an attribute named " + n, this);
                        return new Literal(EmptySequence.getInstance());
                    }
                    this.itemType = new CombinedNodeTest(this.test, 23, new ContentTypeTest(2, schemaType, env.getConfiguration()));
                }
                catch (SchemaException v1) {}
            } else if (this.axis == 3 && kind == 1) {
                try {
                    childElement = targetfp;
                    if (targetfp == -1) {
                        if (((ComplexType)contentType).containsElementWildcard()) {
                            return this;
                        }
                        children = new IntHashSet();
                        ((ComplexType)contentType).gatherAllPermittedChildren(children);
                        if (children.isEmpty()) {
                            env.issueWarning("The complex type " + contentType.getDescription() + " does not allow children", this);
                            return new Literal(EmptySequence.getInstance());
                        }
                        if (children.size() == 1) {
                            iter = children.iterator();
                            if (iter.hasNext()) {
                                childElement = iter.next();
                            }
                        } else {
                            return this;
                        }
                    }
                    if ((schemaType = ((ComplexType)contentType).getElementParticleType(childElement, true)) == null) {
                        n = env.getNamePool().getDisplayName(childElement);
                        env.issueWarning("The complex type " + contentType.getDescription() + " does not allow a child element named " + n, this);
                        return new Literal(EmptySequence.getInstance());
                    }
                    this.itemType = new CombinedNodeTest(this.test, 23, new ContentTypeTest(1, schemaType, env.getConfiguration()));
                    this.computedCardinality = ((ComplexType)contentType).getElementParticleCardinality(childElement, true);
                    visitor.resetStaticProperties();
                    if (this.computedCardinality == 8192) {
                        n = env.getNamePool().getDisplayName(childElement);
                        env.issueWarning("The complex type " + contentType.getDescription() + " appears not to allow a child element named " + n, this);
                        return new Literal(EmptySequence.getInstance());
                    }
                    if (!Cardinality.allowsMany(this.computedCardinality)) {
                        return new FirstItemExpression(this);
                    }
                }
                catch (SchemaException v2) {}
            } else if (this.axis == 4 && kind == 1 && targetfp != -1) {
                try {
                    descendants = new IntHashSet();
                    ((ComplexType)contentType).gatherAllPermittedDescendants(descendants);
                    if (descendants.contains(-1)) {
                        return this;
                    }
                    if (descendants.contains(targetfp)) {
                        children = new IntHashSet();
                        ((ComplexType)contentType).gatherAllPermittedChildren(children);
                        usefulChildren = new IntHashSet();
                        considerSelf = false;
                        considerDescendants = false;
                        child = children.iterator();
                        while (child.hasNext()) {
                            c = child.next();
                            if (c == targetfp) {
                                usefulChildren.add(c);
                                considerSelf = true;
                            }
                            if ((st = ((ComplexType)contentType).getElementParticleType(c, true)) == null) {
                                throw new AssertionError((Object)("Can't find type for element " + c));
                            }
                            if (!(st instanceof ComplexType)) continue;
                            subDescendants = new IntHashSet();
                            ((ComplexType)st).gatherAllPermittedDescendants(subDescendants);
                            if (!subDescendants.contains(targetfp)) continue;
                            usefulChildren.add(c);
                            considerDescendants = true;
                        }
                        if (usefulChildren.size() < children.size()) {
                            childTest = this.makeUnionNodeTest(usefulChildren, visitor.getConfiguration().getNamePool());
                            first = new AxisExpression(3, childTest);
                            ExpressionTool.copyLocationInfo(this, first);
                            nextAxis = considerSelf != false ? (considerDescendants != false ? 5 : 12) : 4;
                            next = new AxisExpression(nextAxis, this.test);
                            ExpressionTool.copyLocationInfo(this, next);
                            path = new PathExpression(first, next);
                            ExpressionTool.copyLocationInfo(this, path);
                            return path.typeCheck(visitor, contextItemType);
                        }
                    } else {
                        n = env.getNamePool().getDisplayName(targetfp);
                        env.issueWarning("The complex type " + contentType.getDescription() + " does not allow a descendant element named " + n, this);
                    }
                }
                catch (SchemaException e) {
                    throw new AssertionError((Object)e);
                }
            }
        }
        return this;
    }

    private NodeTest makeUnionNodeTest(IntHashSet elements, NamePool pool) {
        NodeTest test = null;
        IntIterator iter = elements.iterator();
        while (iter.hasNext()) {
            int fp = iter.next();
            NameTest nextTest = new NameTest(1, fp, pool);
            test = test == null ? nextTest : new CombinedNodeTest(test, 1, nextTest);
        }
        if (test == null) {
            return EmptySequenceTest.getInstance();
        }
        return test;
    }

    public ItemType getContextItemType() {
        return this.contextItemType;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) {
        return this;
    }

    public boolean equals(Object other) {
        if (!(other instanceof AxisExpression)) {
            return false;
        }
        if (this.axis != ((AxisExpression)other).axis) {
            return false;
        }
        if (this.test == null) {
            return ((AxisExpression)other).test == null;
        }
        return this.test.toString().equals(((AxisExpression)other).test.toString());
    }

    public int hashCode() {
        int h = 9375162 + this.axis << 20;
        if (this.test != null) {
            h ^= this.test.getPrimitiveType() << 16;
            h ^= this.test.getFingerprint();
        }
        return h;
    }

    @Override
    public int getIntrinsicDependencies() {
        return 2;
    }

    @Override
    public Expression copy() {
        AxisExpression a2 = new AxisExpression(this.axis, this.test);
        a2.itemType = this.itemType;
        a2.contextItemType = this.contextItemType;
        a2.computedCardinality = this.computedCardinality;
        return a2;
    }

    @Override
    public int computeSpecialProperties() {
        return 0xC10000 | (Axis.isForwards[this.axis] ? 131072 : 262144) | (Axis.isPeerAxis[this.axis] ? 524288 : 0) | (Axis.isSubtreeAxis[this.axis] ? 0x100000 : 0) | (this.axis == 2 || this.axis == 8 ? 0x200000 : 0);
    }

    @Override
    public final ItemType getItemType(TypeHierarchy th) {
        if (this.itemType != null) {
            return this.itemType;
        }
        short p = Axis.principalNodeType[this.axis];
        switch (p) {
            case 2: 
            case 13: {
                return NodeKindTest.makeNodeKindTest(p);
            }
        }
        if (this.test == null) {
            return AnyNodeTest.getInstance();
        }
        return this.test;
    }

    @Override
    public final int computeCardinality() {
        if (this.computedCardinality != -1) {
            return this.computedCardinality;
        }
        if (this.axis == 2 && this.test instanceof NameTest) {
            return 24576;
        }
        if (this.axis == 12) {
            return 24576;
        }
        return 57344;
    }

    @Override
    public boolean isSubtreeExpression() {
        return Axis.isSubtreeAxis[this.axis];
    }

    public byte getAxis() {
        return this.axis;
    }

    public NodeTest getNodeTest() {
        return this.test;
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        if (pathMapNodeSet == null) {
            ContextItemExpression cie = new ContextItemExpression();
            cie.setContainer(this.getContainer());
            pathMapNodeSet = new PathMap.PathMapNodeSet(pathMap.makeNewRoot(cie));
        }
        PathMap.PathMapNodeSet target = pathMapNodeSet.createArc(this);
        return target;
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        Item item = context.getContextItem();
        try {
            if (this.test == null) {
                return ((NodeInfo)item).iterateAxis(this.axis);
            }
            return ((NodeInfo)item).iterateAxis(this.axis, this.test);
        }
        catch (NullPointerException nullPointerException) {
            NamePool pool;
            try {
                pool = context.getConfiguration().getNamePool();
            }
            catch (Exception exception) {
                pool = null;
            }
            XPathException err = new XPathException("The context item for axis step " + (pool == null ? this.toString() : this.toString(pool)) + " is undefined");
            err.setErrorCode("XPDY0002");
            err.setXPathContext(context);
            err.setLocator(this);
            err.setIsTypeError(true);
            throw err;
        }
        catch (ClassCastException classCastException) {
            NamePool pool;
            try {
                pool = context.getConfiguration().getNamePool();
            }
            catch (Exception exception) {
                pool = null;
            }
            XPathException err = new XPathException("The context item for axis step " + (pool == null ? this.toString() : this.toString(pool)) + " is not a node");
            err.setErrorCode("XPTY0020");
            err.setXPathContext(context);
            err.setLocator(this);
            err.setIsTypeError(true);
            throw err;
        }
        catch (UnsupportedOperationException err) {
            this.dynamicError(err.getMessage(), "XPST0010", context);
            return null;
        }
    }

    public SequenceIterator iterate(Item origin) throws XPathException {
        try {
            if (this.test == null) {
                return ((NodeInfo)origin).iterateAxis(this.axis);
            }
            return ((NodeInfo)origin).iterateAxis(this.axis, this.test);
        }
        catch (ClassCastException classCastException) {
            XPathException err = new XPathException("The context item for axis step " + this.toString() + " is not a node");
            err.setErrorCode("XPTY0020");
            err.setLocator(this);
            err.setIsTypeError(true);
            throw err;
        }
    }

    @Override
    public void explain(ExpressionPresenter destination) {
        destination.startElement("axis");
        destination.emitAttribute("name", Axis.axisName[this.axis]);
        destination.emitAttribute("nodeTest", this.test == null ? "node()" : this.test.toString());
        destination.endElement();
    }

    @Override
    public String toString() {
        return String.valueOf(Axis.axisName[this.axis]) + "::" + (this.test == null ? "node()" : this.test.toString());
    }

    public String toString(NamePool pool) {
        return String.valueOf(Axis.axisName[this.axis]) + "::" + (this.test == null ? "node()" : this.test.toString(pool));
    }
}

