/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Stack;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;

public class ExpressionVisitor {
    private Stack<Expression> stack = new Stack();
    private Executable executable;
    private StaticContext staticContext;
    private Configuration configuration;

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public void setExecutable(Executable executable) {
        this.executable = executable;
    }

    public Stack<Expression> getStack() {
        return this.stack;
    }

    public void setStack(Stack<Expression> stack) {
        this.stack = stack;
    }

    public StaticContext getStaticContext() {
        return this.staticContext;
    }

    public void setStaticContext(StaticContext staticContext) {
        this.staticContext = staticContext;
    }

    public Expression getCurrentExpression() {
        return this.stack.peek();
    }

    public static ExpressionVisitor make(StaticContext env) {
        ExpressionVisitor visitor = new ExpressionVisitor();
        visitor.setStaticContext(env);
        visitor.setExecutable(env.getExecutable());
        visitor.setConfiguration(env.getConfiguration());
        return visitor;
    }

    public Expression simplify(Expression exp) throws XPathException {
        if (exp != null) {
            this.stack.push(exp);
            Expression exp2 = exp.simplify(this);
            this.stack.pop();
            return exp2;
        }
        return null;
    }

    public Expression typeCheck(Expression exp, ItemType contextItemType) throws XPathException {
        if (exp != null) {
            this.stack.push(exp);
            Expression exp2 = exp.typeCheck(this, contextItemType);
            this.stack.pop();
            return exp2;
        }
        return null;
    }

    public Expression optimize(Expression exp, ItemType contextItemType) throws XPathException {
        if (exp != null) {
            this.stack.push(exp);
            Expression exp2 = exp.optimize(this, contextItemType);
            this.stack.pop();
            return exp2;
        }
        return null;
    }

    public Expression getParentExpression() {
        int pos = this.stack.size() - 2;
        if (pos > 0) {
            return (Expression)this.stack.get(pos);
        }
        return null;
    }

    public boolean isLoopingSubexpression(Expression ancestor) {
        int top = this.stack.size() - 1;
        while (top > 0) {
            Expression parent = (Expression)this.stack.get(top - 1);
            if (parent.hasLoopingSubexpression((Expression)this.stack.get(top))) {
                return true;
            }
            if (parent == ancestor) {
                return false;
            }
            --top;
        }
        return false;
    }

    public final void resetStaticProperties() {
        for (Expression exp : this.stack) {
            exp.resetLocalStaticProperties();
        }
    }
}

