/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.TailIterator;
import net.sf.saxon.om.ArrayIterator;
import net.sf.saxon.om.GroundedIterator;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LookaheadIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Value;

public class SubsequenceIterator
implements SequenceIterator,
LastPositionFinder,
LookaheadIterator {
    private SequenceIterator base;
    private int position = 0;
    private int min;
    private int max;
    private Item nextItem = null;
    private Item current = null;

    private SubsequenceIterator(SequenceIterator base, int min, int max) throws XPathException {
        this.base = base;
        this.min = min;
        if (min < 1) {
            min = 1;
        }
        this.max = max;
        if (max < min) {
            this.nextItem = null;
            return;
        }
        int i = 1;
        while (i++ <= min) {
            this.nextItem = base.next();
            if (this.nextItem == null) break;
        }
        this.current = this.nextItem;
    }

    public static SequenceIterator make(SequenceIterator base, int min, int max) throws XPathException {
        if (base instanceof ArrayIterator) {
            return ((ArrayIterator)base).makeSliceIterator(min, max);
        }
        if (max == Integer.MAX_VALUE) {
            return TailIterator.make(base, min);
        }
        if (base instanceof GroundedIterator && min > 4) {
            GroundedValue value = ((GroundedIterator)base).materialize();
            value = value.subsequence(min - 1, max - min + 1);
            return ((Value)((Object)value)).iterate();
        }
        return new SubsequenceIterator(base, min, max);
    }

    @Override
    public boolean hasNext() {
        return this.nextItem != null;
    }

    @Override
    public Item next() throws XPathException {
        if (this.nextItem == null) {
            this.current = null;
            this.position = -1;
            return null;
        }
        this.current = this.nextItem;
        ++this.position;
        if (this.base.position() < this.max) {
            this.nextItem = this.base.next();
        } else {
            this.nextItem = null;
            this.base.close();
        }
        return this.current;
    }

    @Override
    public Item current() {
        return this.current;
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public void close() {
        this.base.close();
    }

    @Override
    public SequenceIterator getAnother() throws XPathException {
        return new SubsequenceIterator(this.base.getAnother(), this.min, this.max);
    }

    @Override
    public int getProperties() {
        int p = 4;
        return p |= this.base.getProperties() & 2;
    }

    @Override
    public int getLastPosition() throws XPathException {
        int lastBase = ((LastPositionFinder)this.base).getLastPosition();
        int z = Math.min(lastBase, this.max);
        return Math.max(z - this.min + 1, 0);
    }
}

