/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Arrays;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.StackFrame;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.LocalParam;
import net.sf.saxon.instruct.ParameterSet;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.instruct.UserFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.UnfailingIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.regex.RegexIterator;
import net.sf.saxon.sort.GroupIterator;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.Rule;
import net.sf.saxon.trans.XPathException;

public class XPathContextMajor
extends XPathContextMinor {
    private ParameterSet localParameters;
    private ParameterSet tunnelParameters;
    private UserFunction tailCallFunction;
    private Mode currentMode;
    private Rule currentTemplate;
    private GroupIterator currentGroupIterator;
    private RegexIterator currentRegexIterator;

    public XPathContextMajor(Controller controller) {
        this.controller = controller;
        this.stackFrame = StackFrame.EMPTY;
        this.origin = controller;
    }

    private XPathContextMajor() {
    }

    public XPathContextMajor(Item item, Executable exec) {
        this.controller = new Controller(exec.getConfiguration(), exec);
        if (item != null) {
            UnfailingIterator iter = SingletonIterator.makeIterator(item);
            iter.next();
            this.currentIterator = iter;
        }
        this.origin = this.controller;
    }

    public XPathContextMajor(Item item, Configuration config) {
        Executable exec = new Executable(config);
        exec.setHostLanguage(53);
        this.controller = new Controller(config, exec);
        if (item != null) {
            UnfailingIterator iter = SingletonIterator.makeIterator(item);
            iter.next();
            this.currentIterator = iter;
        }
        this.origin = this.controller;
    }

    @Override
    public XPathContextMajor newContext() {
        XPathContextMajor c = new XPathContextMajor();
        c.controller = this.controller;
        c.currentIterator = this.currentIterator;
        c.stackFrame = this.stackFrame;
        c.localParameters = this.localParameters;
        c.tunnelParameters = this.tunnelParameters;
        c.last = this.last;
        c.currentReceiver = this.currentReceiver;
        c.isTemporaryDestination = this.isTemporaryDestination;
        c.currentMode = this.currentMode;
        c.currentTemplate = this.currentTemplate;
        c.currentRegexIterator = this.currentRegexIterator;
        c.currentGroupIterator = this.currentGroupIterator;
        c.caller = this;
        c.tailCallFunction = null;
        return c;
    }

    public static XPathContextMajor newContext(XPathContextMinor prev) {
        XPathContextMajor c = new XPathContextMajor();
        XPathContext p = prev;
        while (!(p instanceof XPathContextMajor)) {
            p = p.getCaller();
        }
        c.controller = p.getController();
        c.currentIterator = prev.getCurrentIterator();
        c.stackFrame = prev.getStackFrame();
        c.localParameters = p.getLocalParameters();
        c.tunnelParameters = p.getTunnelParameters();
        c.last = prev.last;
        c.currentReceiver = prev.currentReceiver;
        c.isTemporaryDestination = prev.isTemporaryDestination;
        c.currentMode = p.getCurrentMode();
        c.currentTemplate = p.getCurrentTemplateRule();
        c.currentRegexIterator = p.getCurrentRegexIterator();
        c.currentGroupIterator = p.getCurrentGroupIterator();
        c.caller = prev;
        c.tailCallFunction = null;
        return c;
    }

    @Override
    public ParameterSet getLocalParameters() {
        return this.localParameters;
    }

    public void setLocalParameters(ParameterSet localParameters) {
        this.localParameters = localParameters;
    }

    @Override
    public ParameterSet getTunnelParameters() {
        return this.tunnelParameters;
    }

    public void setTunnelParameters(ParameterSet tunnelParameters) {
        this.tunnelParameters = tunnelParameters;
    }

    @Override
    public void setOrigin(InstructionInfo expr) {
        this.origin = expr;
    }

    public void setStackFrame(SlotManager map, ValueRepresentation[] variables) {
        this.stackFrame = new StackFrame(map, variables);
        if (map != null && variables.length != map.getNumberOfVariables()) {
            if (variables.length > map.getNumberOfVariables()) {
                throw new IllegalStateException("Attempting to set more local variables (" + variables.length + ") than the stackframe can accommodate (" + map.getNumberOfVariables() + ")");
            }
            this.stackFrame.slots = new ValueRepresentation[map.getNumberOfVariables()];
            System.arraycopy(variables, 0, this.stackFrame.slots, 0, variables.length);
        }
    }

    public void resetStackFrameMap(SlotManager map, int numberOfParams) {
        this.stackFrame.map = map;
        if (this.stackFrame.slots.length != map.getNumberOfVariables()) {
            ValueRepresentation[] v2 = new ValueRepresentation[map.getNumberOfVariables()];
            System.arraycopy(this.stackFrame.slots, 0, v2, 0, numberOfParams);
            this.stackFrame.slots = v2;
        } else {
            Arrays.fill(this.stackFrame.slots, numberOfParams, this.stackFrame.slots.length, null);
        }
    }

    public void requestTailCall(UserFunction fn, ValueRepresentation[] variables) {
        if (variables.length > this.stackFrame.slots.length) {
            ValueRepresentation[] v2 = new ValueRepresentation[fn.getStackFrameMap().getNumberOfVariables()];
            System.arraycopy(variables, 0, v2, 0, variables.length);
            this.stackFrame.slots = v2;
        } else {
            System.arraycopy(variables, 0, this.stackFrame.slots, 0, variables.length);
        }
        this.tailCallFunction = fn;
    }

    public UserFunction getTailCallFunction() {
        UserFunction fn = this.tailCallFunction;
        this.tailCallFunction = null;
        return fn;
    }

    public void openStackFrame(SlotManager map) {
        int numberOfSlots = map.getNumberOfVariables();
        this.stackFrame = numberOfSlots == 0 ? StackFrame.EMPTY : new StackFrame(map, new ValueRepresentation[numberOfSlots]);
    }

    public void openStackFrame(int numberOfVariables) {
        this.stackFrame = new StackFrame(new SlotManager(numberOfVariables), new ValueRepresentation[numberOfVariables]);
    }

    public void setCurrentMode(Mode mode) {
        this.currentMode = mode;
    }

    @Override
    public Mode getCurrentMode() {
        return this.currentMode;
    }

    public void setCurrentTemplateRule(Rule rule) {
        this.currentTemplate = rule;
    }

    @Override
    public Rule getCurrentTemplateRule() {
        return this.currentTemplate;
    }

    public void setCurrentGroupIterator(GroupIterator iterator) {
        this.currentGroupIterator = iterator;
    }

    @Override
    public GroupIterator getCurrentGroupIterator() {
        return this.currentGroupIterator;
    }

    public void setCurrentRegexIterator(RegexIterator currentRegexIterator) {
        this.currentRegexIterator = currentRegexIterator;
    }

    @Override
    public RegexIterator getCurrentRegexIterator() {
        return this.currentRegexIterator;
    }

    @Override
    public int useLocalParameter(StructuredQName qName, LocalParam binding, boolean isTunnel) throws XPathException {
        ValueRepresentation val;
        ParameterSet params;
        ParameterSet parameterSet = params = isTunnel ? this.getTunnelParameters() : this.localParameters;
        if (params == null) {
            return 0;
        }
        int index = params.getIndex(binding.getParameterId());
        if (index < 0) {
            return 0;
        }
        this.stackFrame.slots[binding.getSlotNumber()] = val = params.getValue(index);
        boolean checked = params.isTypeChecked(index);
        return checked ? 2 : 1;
    }
}

