/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.CollectionURIResolver;
import net.sf.saxon.Controller;
import net.sf.saxon.event.ParseOptions;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Document;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.functions.URIQueryParameters;
import net.sf.saxon.functions.UnparsedText;
import net.sf.saxon.om.AllElementStripper;
import net.sf.saxon.om.ArrayIterator;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.TextFragmentValue;
import org.xml.sax.XMLReader;

public class StandardCollectionURIResolver
implements CollectionURIResolver {
    @Override
    public SequenceIterator resolve(String href, String base, XPathContext context) throws XPathException {
        URI relativeURI;
        if (href == null) {
            return EmptyIterator.getInstance();
        }
        URIQueryParameters params = null;
        try {
            relativeURI = new URI(ResolveURI.escapeSpaces(href));
            String query = relativeURI.getQuery();
            if (query != null) {
                params = new URIQueryParameters(query, context.getConfiguration());
                int q = href.indexOf(63);
                href = ResolveURI.escapeSpaces(href.substring(0, q));
                relativeURI = new URI(href);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            XPathException err = new XPathException("Invalid relative URI " + Err.wrap(href, 4) + " passed to collection() function");
            err.setErrorCode("FODC0004");
            err.setXPathContext(context);
            throw err;
        }
        URI resolvedURI = this.makeAbsoluteURI(href, base, context, relativeURI);
        if ("file".equals(resolvedURI.getScheme())) {
            File file = new File(resolvedURI);
            if (!file.exists()) {
                XPathException err = new XPathException("The file or directory " + resolvedURI + " does not exist");
                err.setErrorCode("FODC0004");
                err.setXPathContext(context);
                throw err;
            }
            if (file.isDirectory()) {
                return this.directoryContents(file, params, context);
            }
        }
        return this.catalogContents(href, base, resolvedURI.toString(), context);
    }

    protected URI makeAbsoluteURI(String href, String base, XPathContext context, URI relativeURI) throws XPathException {
        URI resolvedURI;
        if (!relativeURI.isAbsolute()) {
            if (base == null && (base = ResolveURI.tryToExpand(base)) == null) {
                XPathException err = new XPathException("Cannot resolve relative URI: no base URI available");
                err.setErrorCode("FODC0004");
                err.setXPathContext(context);
                throw err;
            }
            try {
                resolvedURI = ResolveURI.makeAbsolute(href, base);
            }
            catch (URISyntaxException e) {
                XPathException err = new XPathException("Cannot resolve relative URI: " + e.getMessage());
                err.setErrorCode("FODC0004");
                err.setXPathContext(context);
                throw err;
            }
        } else {
            resolvedURI = relativeURI;
        }
        return resolvedURI;
    }

    private SequenceIterator directoryContents(File directory, URIQueryParameters params, XPathContext context) {
        FilenameFilter f;
        FilenameFilter filter = null;
        if (params != null && (f = params.getFilenameFilter()) != null) {
            filter = f;
        }
        File[] files = filter == null ? directory.listFiles() : directory.listFiles(filter);
        Item[] fileValues = new ObjectValue[files.length];
        int f2 = 0;
        while (f2 < files.length) {
            fileValues[f2] = new ObjectValue(files[f2]);
            ++f2;
        }
        int onError = 1;
        if (params != null && params.getOnError() != null) {
            onError = params.getOnError();
        }
        Controller controller = context.getController();
        PipelineConfiguration oldPipe = controller.makePipelineConfiguration();
        PipelineConfiguration newPipe = new PipelineConfiguration(oldPipe);
        final ErrorListener oldErrorListener = controller.getErrorListener();
        if (onError == 3) {
            newPipe.setErrorListener(new ErrorListener(){

                @Override
                public void warning(TransformerException exception) {
                }

                @Override
                public void error(TransformerException exception) {
                }

                @Override
                public void fatalError(TransformerException exception) {
                }
            });
        } else if (onError == 2) {
            newPipe.setErrorListener(new ErrorListener(){

                @Override
                public void warning(TransformerException exception) throws TransformerException {
                    oldErrorListener.warning(exception);
                }

                @Override
                public void error(TransformerException exception) throws TransformerException {
                    oldErrorListener.warning(exception);
                    XPathException supp = new XPathException("The document will be excluded from the collection");
                    supp.setLocator(exception.getLocator());
                    oldErrorListener.warning(supp);
                }

                @Override
                public void fatalError(TransformerException exception) throws TransformerException {
                    this.error(exception);
                }
            });
        }
        FileExpander expander = new FileExpander(params, newPipe);
        ArrayIterator base = new ArrayIterator(fileValues);
        return new MappingIterator(base, expander);
    }

    private SequenceIterator catalogContents(String href, String baseURI, String absURI, final XPathContext context) throws XPathException {
        boolean stable = true;
        NamePool pool = context.getController().getNamePool();
        Source source = Document.resolveURI(href, baseURI, null, context.getController());
        ParseOptions options = new ParseOptions();
        options.setSchemaValidationMode(4);
        DocumentInfo catalog = context.getConfiguration().buildDocument(source, options);
        if (catalog == null) {
            XPathException err = new XPathException("Failed to load collection catalog " + absURI);
            err.setErrorCode("FODC0004");
            err.setXPathContext(context);
            throw err;
        }
        AxisIterator iter = catalog.iterateAxis((byte)3, NodeKindTest.ELEMENT);
        NodeInfo top = (NodeInfo)iter.next();
        if (top == null || !"collection".equals(top.getLocalPart()) || top.getURI().length() != 0) {
            XPathException err = new XPathException("collection catalog must contain top-level element <collection>");
            err.setErrorCode("FODC0004");
            err.setXPathContext(context);
            throw err;
        }
        iter.close();
        String stableAtt = top.getAttributeValue(pool.allocate("", "", "stable"));
        if (stableAtt != null) {
            if ("true".equals(stableAtt)) {
                stable = true;
            } else if ("false".equals(stableAtt)) {
                stable = false;
            } else {
                XPathException err = new XPathException("The 'stable' attribute of element <collection> must be true or false");
                err.setErrorCode("FODC0004");
                err.setXPathContext(context);
                throw err;
            }
        }
        final boolean finalStable = stable;
        AxisIterator documents = top.iterateAxis((byte)3, NodeKindTest.ELEMENT);
        ItemMappingFunction catalogueMapper = new ItemMappingFunction(){

            @Override
            public Item map(Item item) throws XPathException {
                String uri;
                NodeInfo element = (NodeInfo)item;
                if (!"doc".equals(element.getLocalPart()) || element.getURI().length() != 0) {
                    XPathException err = new XPathException("children of <collection> element must be <doc> elements");
                    err.setErrorCode("FODC0004");
                    err.setXPathContext(context);
                    throw err;
                }
                String href = Navigator.getAttributeValue(element, "", "href");
                if (href == null) {
                    XPathException err = new XPathException("\"<doc> element in catalog has no @href attribute\"");
                    err.setErrorCode("FODC0004");
                    err.setXPathContext(context);
                    throw err;
                }
                try {
                    uri = new URI(element.getBaseURI()).resolve(href).toString();
                }
                catch (URISyntaxException uRISyntaxException) {
                    XPathException err = new XPathException("Invalid base URI or href URI in collection catalog: (" + element.getBaseURI() + ", " + href + ")");
                    err.setErrorCode("FODC0004");
                    err.setXPathContext(context);
                    throw err;
                }
                if (finalStable) {
                    return new AnyURIValue(uri);
                }
                return context.getConfiguration().buildDocument(new StreamSource(uri));
            }
        };
        return new ItemMappingIterator(documents, catalogueMapper);
    }

    private static class FileExpander
    implements MappingFunction {
        private URIQueryParameters params;
        boolean recurse = false;
        int strip = 3;
        int validation = 4;
        Boolean xinclude = null;
        boolean unparsed;
        XMLReader parser = null;
        int onError = 1;
        FilenameFilter filter = null;
        PipelineConfiguration pipe;

        public FileExpander(URIQueryParameters params, PipelineConfiguration pipe) {
            this.params = params;
            this.pipe = pipe;
            if (params != null) {
                XMLReader p;
                Integer v;
                Boolean r;
                FilenameFilter f = params.getFilenameFilter();
                if (f != null) {
                    this.filter = f;
                }
                if ((r = params.getRecurse()) != null) {
                    this.recurse = r;
                }
                if ((v = params.getValidationMode()) != null) {
                    this.validation = v;
                }
                this.xinclude = params.getXInclude();
                this.strip = params.getStripSpace();
                this.unparsed = params.isUnparsed();
                Integer e = params.getOnError();
                if (e != null) {
                    this.onError = e;
                }
                if ((p = params.getXMLReader()) != null) {
                    this.parser = p;
                }
            }
        }

        @Override
        public SequenceIterator map(Item item) throws XPathException {
            File file = (File)((ObjectValue)item).getObject();
            if (file.isDirectory()) {
                if (this.recurse) {
                    File[] files = this.filter == null ? file.listFiles() : file.listFiles(this.filter);
                    Item[] fileValues = new ObjectValue[files.length];
                    int f = 0;
                    while (f < files.length) {
                        fileValues[f] = new ObjectValue(files[f]);
                        ++f;
                    }
                    FileExpander expander = new FileExpander(this.params, this.pipe);
                    return new MappingIterator(new ArrayIterator(fileValues), expander);
                }
                return null;
            }
            if (this.unparsed) {
                try {
                    FileReader reader = new FileReader(file);
                    NameChecker checker = this.pipe.getConfiguration().getNameChecker();
                    CharSequence content = UnparsedText.readFile(checker, reader);
                    String uri = file.toURI().toString();
                    TextFragmentValue doc = new TextFragmentValue(content, uri);
                    doc.setSystemId(file.toURI().toString());
                    doc.setConfiguration(this.pipe.getConfiguration());
                    return SingletonIterator.makeIterator(doc);
                }
                catch (IOException err) {
                    if (this.onError == 3) {
                        return null;
                    }
                    if (this.onError == 2) {
                        try {
                            XPathException warn = new XPathException("Failed to read " + file.getPath(), err);
                            this.pipe.getErrorListener().warning(warn);
                            XPathException supp = new XPathException("The document will be excluded from the collection");
                            this.pipe.getErrorListener().warning(supp);
                        }
                        catch (TransformerException transformerException) {}
                        return null;
                    }
                    throw new XPathException("Failed to read " + file.getPath(), err);
                }
            }
            try {
                StreamSource source = new StreamSource(file.toURI().toString());
                ParseOptions options = new ParseOptions();
                if (this.validation != 4 && this.validation != 3) {
                    options.setSchemaValidationMode(this.validation);
                }
                if (this.xinclude != null) {
                    options.setXIncludeAware(this.xinclude);
                }
                if (this.parser != null) {
                    options.setXMLReader(this.parser);
                }
                if (this.params != null) {
                    int stripSpace = this.params.getStripSpace();
                    switch (this.strip) {
                        case 2: {
                            AllElementStripper stripper = AllElementStripper.getInstance();
                            stripper.setStripAll();
                            options.addFilter(stripper);
                            break;
                        }
                        case 0: 
                        case 1: {
                            options.setStripSpace(stripSpace);
                        }
                    }
                }
                DocumentInfo doc = this.pipe.getConfiguration().buildDocument(source, options);
                return SingletonIterator.makeIterator(doc);
            }
            catch (XPathException err) {
                if (this.onError == 3) {
                    return null;
                }
                if (this.onError == 2) {
                    try {
                        if (!err.hasBeenReported()) {
                            this.pipe.getErrorListener().warning(err);
                            XPathException supp = new XPathException("The document will be excluded from the collection");
                            supp.setLocator(err.getLocator());
                            this.pipe.getErrorListener().warning(supp);
                        }
                    }
                    catch (TransformerException transformerException) {}
                    return null;
                }
                throw err;
            }
        }
    }
}

