/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.AttributeSet;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;

public class UseAttributeSets
extends Instruction {
    private AttributeSet[] attributeSets;

    public UseAttributeSets(AttributeSet[] sets) {
        this.attributeSets = sets;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        return this;
    }

    @Override
    public Expression copy() {
        throw new UnsupportedOperationException("copy");
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        return this;
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return NodeKindTest.ATTRIBUTE;
    }

    @Override
    public int getIntrinsicDependencies() {
        int d = 0;
        int i = 0;
        while (i < this.attributeSets.length) {
            AttributeSet as = this.attributeSets[i];
            d |= as.getFocusDependencies();
            ++i;
        }
        return d;
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        AttributeSet.expand(this.attributeSets, context);
        return null;
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("useAttributeSets");
        int i = 0;
        while (i < this.attributeSets.length) {
            AttributeSet as = this.attributeSets[i];
            out.startElement("useAttributeSet");
            out.emitAttribute("name", as.getObjectName().getDisplayName());
            out.endElement();
            ++i;
        }
        out.endElement();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UseAttributeSets)) {
            return false;
        }
        if (this.attributeSets.length != ((UseAttributeSets)obj).attributeSets.length) {
            return false;
        }
        int i = 0;
        while (i < this.attributeSets.length) {
            AttributeSet as0 = this.attributeSets[i];
            AttributeSet as1 = ((UseAttributeSets)obj).attributeSets[i];
            if (!as0.getObjectName().equals(as1.getObjectName())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int h = -2042480871;
        int i = 0;
        while (i < this.attributeSets.length) {
            h ^= this.attributeSets[i].getObjectName().hashCode();
            ++i;
        }
        return h;
    }
}

