/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.util.HashMap;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLFilterImpl;

public class PrefixNormalizer
extends XMLFilterImpl {
    private HashMap uriToPrefix = new HashMap();
    private Stack prefixes = new Stack();
    private Stack uris = new Stack();

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        super.startPrefixMapping(prefix, uri);
        this.prefixes.push(prefix);
        this.uris.push(uri);
        if (this.uriToPrefix.get(uri) == null) {
            this.uriToPrefix.put(uri, prefix);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        String preferredPrefix;
        if (uri.length() != 0 && !qName.startsWith(preferredPrefix = (String)this.uriToPrefix.get(uri))) {
            String cfr_ignored_0 = String.valueOf(preferredPrefix) + ':' + localName;
        }
        int alen = atts.getLength();
        int a = 0;
        while (a < alen) {
            ++a;
        }
        super.startElement(uri, localName, qName, atts);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        super.endPrefixMapping(prefix);
    }
}

