/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.ReversibleIterator;
import net.sf.saxon.om.ArrayIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LookaheadIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.UnfailingIterator;

public class ReverseArrayIterator
implements UnfailingIterator,
ReversibleIterator,
LookaheadIterator,
LastPositionFinder {
    Item[] items;
    int index = 0;
    int start;
    int end;
    Item current = null;

    public ReverseArrayIterator(Item[] items, int start, int end) {
        this.items = items;
        this.end = end;
        this.start = start;
        this.index = end - 1;
    }

    @Override
    public boolean hasNext() {
        return this.index >= this.start;
    }

    @Override
    public Item next() {
        if (this.index >= this.start) {
            this.current = this.items[this.index--];
            return this.current;
        }
        this.current = null;
        return null;
    }

    @Override
    public Item current() {
        return this.current;
    }

    @Override
    public int position() {
        if (this.index < this.start - 1) {
            return -1;
        }
        return this.end - 1 - this.index;
    }

    @Override
    public int getLastPosition() {
        return this.end - this.start;
    }

    @Override
    public void close() {
    }

    @Override
    public SequenceIterator getAnother() {
        return new ReverseArrayIterator(this.items, this.start, this.end);
    }

    @Override
    public int getProperties() {
        return 2;
    }

    @Override
    public SequenceIterator getReverseIterator() {
        return new ArrayIterator(this.items, this.start, this.end);
    }
}

