/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.io.PrintStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.SaxonApiUncheckedException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.ValidationMode;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmEmptySequence;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.trace.TraceListener;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceExtent;

public class XQueryEvaluator
implements Iterable<XdmItem> {
    private Processor processor;
    private XQueryExpression expression;
    private DynamicQueryContext context;
    private Destination destination;
    private Set<XdmNode> updatedDocuments;

    protected XQueryEvaluator(Processor processor, XQueryExpression expression) {
        this.processor = processor;
        this.expression = expression;
        this.context = new DynamicQueryContext(expression.getExecutable().getConfiguration());
    }

    public void setSchemaValidationMode(ValidationMode mode) {
        if (mode != null) {
            this.context.setSchemaValidationMode(mode.getNumber());
        }
    }

    public ValidationMode getSchemaValidationMode() {
        return ValidationMode.get(this.context.getSchemaValidationMode());
    }

    public void setSource(Source source) throws SaxonApiException {
        if (source instanceof NodeInfo) {
            this.setContextItem(new XdmNode((NodeInfo)source));
        } else if (source instanceof DOMSource) {
            this.setContextItem(this.processor.newDocumentBuilder().wrap(source));
        } else {
            this.setContextItem(this.processor.newDocumentBuilder().build(source));
        }
    }

    public void setContextItem(XdmItem item) {
        this.context.setContextItem(item == null ? null : (Item)item.getUnderlyingValue());
    }

    public XdmItem getContextItem() {
        return (XdmItem)XdmValue.wrap(this.context.getContextItem());
    }

    public void setExternalVariable(QName name, XdmValue value) {
        this.context.setParameter(name.getClarkName(), value == null ? null : value.getUnderlyingValue());
    }

    public XdmValue getExternalVariable(QName name) {
        Object oval = this.context.getParameter(name.getClarkName());
        if (oval == null) {
            return null;
        }
        if (oval instanceof ValueRepresentation) {
            return XdmValue.wrap((ValueRepresentation)oval);
        }
        throw new IllegalStateException(oval.getClass().getName());
    }

    public void setURIResolver(URIResolver resolver) {
        this.context.setURIResolver(resolver);
    }

    public URIResolver getURIResolver() {
        return this.context.getURIResolver();
    }

    public void setErrorListener(ErrorListener listener) {
        this.context.setErrorListener(listener);
    }

    public ErrorListener getErrorListener() {
        return this.context.getErrorListener();
    }

    public void setTraceListener(TraceListener listener) {
        this.context.setTraceListener(listener);
    }

    public TraceListener getTraceListener() {
        return this.context.getTraceListener();
    }

    public void setTraceFunctionDestination(PrintStream stream) {
        this.context.setTraceFunctionDestination(stream);
    }

    public PrintStream getTraceFunctionDestination() {
        return this.context.getTraceFunctionDestination();
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public void run() throws SaxonApiException {
        try {
            if (this.expression.isUpdateQuery()) {
                Set docs = this.expression.runUpdate(this.context);
                this.updatedDocuments = new HashSet<XdmNode>();
                for (NodeInfo root : docs) {
                    this.updatedDocuments.add((XdmNode)XdmNode.wrapItem(root));
                }
            } else {
                if (this.destination == null) {
                    throw new IllegalStateException("No destination supplied");
                }
                Receiver receiver = this.destination instanceof Serializer ? ((Serializer)this.destination).getReceiver(this.expression.getExecutable().getConfiguration(), null, this.expression.getExecutable().getDefaultOutputProperties()) : this.destination.getReceiver(this.expression.getExecutable().getConfiguration());
                this.expression.run(this.context, receiver, null);
                if (this.destination instanceof Serializer) {
                    ((Serializer)this.destination).close();
                }
            }
        }
        catch (TransformerException e) {
            throw new SaxonApiException(e);
        }
    }

    public void run(Destination destination) throws SaxonApiException {
        if (this.expression.isUpdateQuery()) {
            throw new IllegalStateException("Query is updating");
        }
        try {
            Receiver receiver = destination instanceof Serializer ? ((Serializer)destination).getReceiver(this.expression.getExecutable().getConfiguration(), null, this.expression.getExecutable().getDefaultOutputProperties()) : destination.getReceiver(this.expression.getExecutable().getConfiguration());
            this.expression.run(this.context, receiver, null);
        }
        catch (TransformerException e) {
            throw new SaxonApiException(e);
        }
    }

    public XdmValue evaluate() throws SaxonApiException {
        if (this.expression.isUpdateQuery()) {
            throw new IllegalStateException("Query is updating");
        }
        try {
            SequenceIterator iter = this.expression.iterator(this.context);
            ValueRepresentation result = SequenceExtent.makeSequenceExtent(iter);
            if (result instanceof NodeInfo) {
                return new XdmNode((NodeInfo)result);
            }
            if (result instanceof AtomicValue) {
                return new XdmAtomicValue((AtomicValue)result);
            }
            if (result instanceof EmptySequence) {
                return XdmEmptySequence.getInstance();
            }
            return new XdmValue(result);
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    public XdmItem evaluateSingle() throws SaxonApiException {
        try {
            SequenceIterator iter = this.expression.iterator(this.context);
            return (XdmItem)XdmValue.wrap(iter.next());
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    @Override
    public Iterator<XdmItem> iterator() throws SaxonApiUncheckedException {
        if (this.expression.isUpdateQuery()) {
            throw new IllegalStateException("Query is updating");
        }
        try {
            return new XdmSequenceIterator(this.expression.iterator(this.context));
        }
        catch (XPathException e) {
            throw new SaxonApiUncheckedException(e);
        }
    }

    public Iterator<XdmNode> getUpdatedDocuments() {
        return this.updatedDocuments.iterator();
    }

    public DynamicQueryContext getUnderlyingQueryContext() {
        return this.context;
    }
}

