/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.PathExpression;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.DocumentOrderIterator;
import net.sf.saxon.sort.GlobalOrderComparer;
import net.sf.saxon.sort.LocalOrderComparer;
import net.sf.saxon.sort.NodeOrderComparer;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;

public class DocumentSorter
extends UnaryExpression {
    private NodeOrderComparer comparer;

    public DocumentSorter(Expression base) {
        super(base);
        int props = base.getSpecialProperties();
        this.comparer = (props & 0x10000) != 0 || (props & 0x800000) != 0 ? LocalOrderComparer.getInstance() : GlobalOrderComparer.getInstance();
    }

    public NodeOrderComparer getComparer() {
        return this.comparer;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.operand = visitor.simplify(this.operand);
        if ((this.operand.getSpecialProperties() & 0x20000) != 0) {
            return this.operand;
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.operand = visitor.optimize(this.operand, contextItemType);
        if ((this.operand.getSpecialProperties() & 0x20000) != 0) {
            return this.operand;
        }
        if (this.operand instanceof PathExpression) {
            return visitor.getConfiguration().getOptimizer().makeConditionalDocumentSorter(this, (PathExpression)this.operand);
        }
        return this;
    }

    @Override
    public int computeSpecialProperties() {
        return this.operand.getSpecialProperties() | 0x20000;
    }

    @Override
    public Expression copy() {
        return new DocumentSorter(this.getBaseExpression().copy());
    }

    @Override
    public Expression promote(PromotionOffer offer, Expression parent) throws XPathException {
        Expression exp = offer.accept(parent, this);
        if (exp != null) {
            return exp;
        }
        this.operand = this.doPromotion(this, this.operand, offer);
        return this;
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        return new DocumentOrderIterator(this.operand.iterate(context), this.comparer);
    }

    @Override
    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        return this.operand.effectiveBooleanValue(context);
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("sortAndDeduplicate");
        out.emitAttribute("intraDocument", this.comparer instanceof LocalOrderComparer ? "true" : "false");
        this.operand.explain(out);
        out.endElement();
    }
}

