/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.Arrays;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.instruct.UserFunction;
import net.sf.saxon.instruct.UserFunctionParameter;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.XSLFunction;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;

public class StylesheetFunctionLibrary
implements FunctionLibrary {
    private XSLStylesheet stylesheet;
    private boolean overriding;

    public StylesheetFunctionLibrary(XSLStylesheet sheet, boolean overriding) {
        this.stylesheet = sheet;
        this.overriding = overriding;
    }

    @Override
    public SequenceType[] getFunctionSignature(StructuredQName functionName, int arity) {
        XSLFunction fn = this.stylesheet.getStylesheetFunction(functionName, arity);
        if (fn != null) {
            Object[] sig = new SequenceType[arity + 1];
            UserFunction uf = fn.getCompiledFunction();
            if (uf == null) {
                Arrays.fill(sig, SequenceType.ANY_SEQUENCE);
            } else {
                UserFunctionParameter[] params = uf.getParameterDefinitions();
                sig[0] = uf.getResultType(this.stylesheet.getConfiguration().getTypeHierarchy());
                int i = 0;
                while (i < params.length) {
                    sig[i + 1] = params[i].getRequiredType();
                    ++i;
                }
            }
            return sig;
        }
        return null;
    }

    @Override
    public Expression bind(StructuredQName functionName, Expression[] staticArgs, StaticContext env) throws XPathException {
        XSLFunction fn = this.stylesheet.getStylesheetFunction(functionName, staticArgs.length);
        if (fn == null) {
            return null;
        }
        if (fn.isOverriding() != this.overriding) {
            return null;
        }
        UserFunctionCall fc = new UserFunctionCall();
        fn.registerReference(fc);
        fc.setFunctionName(functionName);
        fc.setArguments(staticArgs);
        fc.setConfirmed(true);
        return fc;
    }

    @Override
    public FunctionLibrary copy() {
        return this;
    }

    public List getAllFunctions() {
        return this.stylesheet.getAllStylesheetFunctions();
    }
}

