/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import javax.xml.transform.SourceLocator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;
import org.xml.sax.Locator;

public class ValidationException
extends XPathException
implements SourceLocator,
Locator {
    private String systemId;
    private String publicId;
    private int lineNumber = -1;
    private int columnNumber = -1;
    private NodeInfo node;
    private int schemaPart = -1;
    private String constraintName;
    private String constraintClauseNumber;

    public ValidationException(String message) {
        super(message);
        this.setIsTypeError(true);
    }

    public ValidationException(Exception exception) {
        super(exception);
        this.setIsTypeError(true);
    }

    public ValidationException(String message, Exception exception) {
        super(message, exception);
        this.setIsTypeError(true);
    }

    public ValidationException(String message, SourceLocator locator) {
        super(message, locator);
        this.setIsTypeError(true);
        this.setSourceLocator(locator);
    }

    public void setConstraintReference(int schemaPart, String constraintName, String clause) {
        this.schemaPart = schemaPart;
        this.constraintName = constraintName;
        this.constraintClauseNumber = clause;
    }

    public void setConstraintReference(ValidationException e) {
        this.schemaPart = e.schemaPart;
        this.constraintName = e.constraintName;
        this.constraintClauseNumber = e.constraintClauseNumber;
    }

    public String getConstraintReferenceMessage() {
        if (this.schemaPart == -1) {
            return null;
        }
        return "See http://www.w3.org/TR/xmlschema-" + this.schemaPart + "/#" + this.constraintName + " clause " + this.constraintClauseNumber;
    }

    public int getConstraintSchemaPart() {
        return this.schemaPart;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public String getConstraintClauseNumber() {
        return this.constraintClauseNumber;
    }

    public String getConstraintReference() {
        return String.valueOf(this.constraintName) + '.' + this.constraintClauseNumber;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("ValidationException: ");
        String message = this.getMessage();
        if (message != null) {
            sb.append(message);
        }
        return sb.toString();
    }

    @Override
    public String getPublicId() {
        SourceLocator loc = this.getLocator();
        if (this.publicId == null && loc != null && loc != this) {
            return loc.getPublicId();
        }
        return this.publicId;
    }

    @Override
    public String getSystemId() {
        SourceLocator loc = this.getLocator();
        if (this.systemId == null && loc != null && loc != this) {
            return loc.getSystemId();
        }
        return this.systemId;
    }

    @Override
    public int getLineNumber() {
        SourceLocator loc = this.getLocator();
        if (this.lineNumber == -1 && loc != null && loc != this) {
            return loc.getLineNumber();
        }
        return this.lineNumber;
    }

    @Override
    public int getColumnNumber() {
        SourceLocator loc = this.getLocator();
        if (this.columnNumber == -1 && loc != null && loc != this) {
            return loc.getColumnNumber();
        }
        return this.columnNumber;
    }

    public NodeInfo getNode() {
        return this.node;
    }

    public void setPublicId(String id) {
        this.publicId = id;
    }

    public void setSystemId(String id) {
        this.systemId = id;
    }

    public void setLineNumber(int line) {
        this.lineNumber = line;
    }

    public void setColumnNumber(int column) {
        this.columnNumber = column;
    }

    public void setLocator(Locator locator) {
        if (locator != null) {
            this.setPublicId(locator.getPublicId());
            this.setSystemId(locator.getSystemId());
            this.setLineNumber(locator.getLineNumber());
            this.setColumnNumber(locator.getColumnNumber());
            if (locator instanceof NodeInfo) {
                this.node = (NodeInfo)((Object)locator);
            }
        }
        super.setLocator(null);
    }

    public void setSourceLocator(SourceLocator locator) {
        if (locator != null) {
            this.setPublicId(locator.getPublicId());
            this.setSystemId(locator.getSystemId());
            this.setLineNumber(locator.getLineNumber());
            this.setColumnNumber(locator.getColumnNumber());
            if (locator instanceof NodeInfo) {
                this.node = (NodeInfo)((Object)locator);
            }
        }
        super.setLocator(null);
    }

    @Override
    public SourceLocator getLocator() {
        SourceLocator loc = super.getLocator();
        if (loc != null) {
            return loc;
        }
        return this;
    }
}

