/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.regex.Pattern;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.value.Whitespace;

public final class DecimalValue
extends NumericValue {
    public static final int DIVIDE_PRECISION = 18;
    private static boolean canSetScaleNegative = true;
    private BigDecimal value;
    public static final BigDecimal BIG_DECIMAL_ONE = BigDecimal.valueOf(1L);
    public static final BigInteger BIG_INTEGER_TEN = BigInteger.valueOf(10L);
    public static final BigDecimal BIG_DECIMAL_ONE_MILLION = BigDecimal.valueOf(1000000L);
    public static final DecimalValue ZERO = new DecimalValue(BigDecimal.valueOf(0L));
    public static final DecimalValue ONE = new DecimalValue(BigDecimal.valueOf(1L));
    private static final Pattern decimalPattern = Pattern.compile("(\\-|\\+)?((\\.[0-9]+)|([0-9]+(\\.[0-9]*)?))");

    public DecimalValue(BigDecimal value) {
        this.value = value.stripTrailingZeros();
        this.typeLabel = BuiltInAtomicType.DECIMAL;
    }

    /*
     * Unable to fully structure code
     */
    public static ConversionResult makeDecimalValue(CharSequence in, boolean validate) {
        try {
            digits = new FastStringBuffer(in.length());
            scale = 0;
            state = 0;
            foundDigit = false;
            len = in.length();
            i = 0;
            while (i < len) {
                c = in.charAt(i);
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        if (state == 0) break;
                        state = 5;
                        break;
                    }
                    case '+': {
                        if (state != 0) {
                            throw new NumberFormatException("unexpected sign");
                        }
                        state = 1;
                        break;
                    }
                    case '-': {
                        if (state != 0) {
                            throw new NumberFormatException("unexpected sign");
                        }
                        state = 1;
                        digits.append(c);
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        if (state == 0) {
                            state = 1;
                        } else if (state >= 3) {
                            ++scale;
                        }
                        if (state == 5) {
                            throw new NumberFormatException("contains embedded whitespace");
                        }
                        digits.append(c);
                        foundDigit = true;
                        break;
                    }
                    case '.': {
                        if (state == 5) {
                            throw new NumberFormatException("contains embedded whitespace");
                        }
                        if (state >= 3) {
                            throw new NumberFormatException("more than one decimal point");
                        }
                        state = 3;
                        break;
                    }
                    default: {
                        throw new NumberFormatException("invalid character '" + c + "'");
                    }
                }
                ++i;
            }
            if (foundDigit) ** GOTO lbl53
            throw new NumberFormatException("no digits in value");
            while (digits.charAt(digits.length() - 1) == '0') {
                digits.setLength(digits.length() - 1);
                --scale;
lbl53:
                // 2 sources

                if (scale > 0) continue;
            }
            if (digits.length() == 0 || digits.length() == 1 && digits.charAt(0) == '-') {
                return DecimalValue.ZERO;
            }
            bigInt = new BigInteger(digits.toString());
            bigDec = new BigDecimal(bigInt, scale);
            return new DecimalValue(bigDec);
        }
        catch (NumberFormatException err) {
            e = new ValidationFailure("Cannot convert string " + Err.wrap(Whitespace.trim(in), 4) + " to xs:decimal: " + err.getMessage());
            e.setErrorCode("FORG0001");
            return e;
        }
    }

    public static boolean castableAsDecimal(CharSequence in) {
        CharSequence trimmed = Whitespace.trimWhitespace(in);
        return decimalPattern.matcher(trimmed).matches();
    }

    public DecimalValue(double in) throws ValidationException {
        try {
            BigDecimal d = new BigDecimal(in);
            this.value = d.stripTrailingZeros();
        }
        catch (NumberFormatException numberFormatException) {
            ValidationException e = new ValidationException("Cannot convert double " + Err.wrap(String.valueOf(in), 4) + " to decimal");
            e.setErrorCode("FOCA0002");
            throw e;
        }
        this.typeLabel = BuiltInAtomicType.DECIMAL;
    }

    public DecimalValue(long in) {
        this.value = BigDecimal.valueOf(in);
        this.typeLabel = BuiltInAtomicType.DECIMAL;
    }

    @Override
    public AtomicValue copyAsSubType(AtomicType typeLabel) {
        DecimalValue v = new DecimalValue(this.value);
        v.typeLabel = typeLabel;
        return v;
    }

    @Override
    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.DECIMAL;
    }

    @Override
    public BigDecimal getDecimalValue() {
        return this.value;
    }

    @Override
    public int hashCode() {
        BigDecimal round = this.value.setScale(0, 1);
        long value = round.longValue();
        if (value > Integer.MIN_VALUE && value < Integer.MAX_VALUE) {
            return (int)value;
        }
        return new Double(this.getDoubleValue()).hashCode();
    }

    @Override
    public boolean effectiveBooleanValue() {
        return this.value.signum() != 0;
    }

    @Override
    public ConversionResult convertPrimitive(BuiltInAtomicType requiredType, boolean validate, XPathContext context) {
        switch (requiredType.getFingerprint()) {
            case 514: {
                return BooleanValue.get(this.value.signum() != 0);
            }
            case 515: 
            case 632: 
            case 635: {
                return this;
            }
            case 532: {
                return BigIntegerValue.makeIntegerValue(this.value.toBigInteger());
            }
            case 533: 
            case 534: 
            case 535: 
            case 536: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 541: 
            case 542: 
            case 543: 
            case 544: {
                IntegerValue iv = BigIntegerValue.makeIntegerValue(this.value.toBigInteger());
                return iv.convertPrimitive(requiredType, validate, context);
            }
            case 517: {
                return new DoubleValue(this.value.doubleValue());
            }
            case 516: {
                return new FloatValue(this.value.floatValue());
            }
            case 513: {
                return new StringValue(this.getStringValueCS());
            }
            case 631: {
                return new UntypedAtomicValue(this.getStringValueCS());
            }
        }
        ValidationFailure err = new ValidationFailure("Cannot convert decimal to " + requiredType.getDisplayName());
        err.setErrorCode("XPTY0004");
        return err;
    }

    @Override
    public CharSequence getCanonicalLexicalRepresentation() {
        String s = this.getStringValue();
        if (s.indexOf(46) < 0) {
            s = String.valueOf(s) + ".0";
        }
        return s;
    }

    @Override
    public CharSequence getPrimitiveStringValue() {
        return DecimalValue.decimalToString(this.value, new FastStringBuffer(16));
    }

    public static FastStringBuffer decimalToString(BigDecimal value, FastStringBuffer fsb) {
        int scale = value.scale();
        if (scale == 0) {
            fsb.append(value.toString());
            return fsb;
        }
        if (scale < 0) {
            String s = value.abs().unscaledValue().toString();
            if (s.equals("0")) {
                fsb.append('0');
                return fsb;
            }
            if (value.signum() < 0) {
                fsb.append('-');
            }
            fsb.append(s);
            int i = 0;
            while (i < -scale) {
                fsb.append('0');
                ++i;
            }
            return fsb;
        }
        String s = value.abs().unscaledValue().toString();
        if (s.equals("0")) {
            fsb.append('0');
            return fsb;
        }
        int len = s.length();
        if (value.signum() < 0) {
            fsb.append('-');
        }
        if (scale >= len) {
            fsb.append("0.");
            int i = len;
            while (i < scale) {
                fsb.append('0');
                ++i;
            }
            fsb.append(s);
        } else {
            fsb.append(s.substring(0, len - scale));
            fsb.append('.');
            fsb.append(s.substring(len - scale));
        }
        return fsb;
    }

    @Override
    public NumericValue negate() {
        return new DecimalValue(this.value.negate());
    }

    @Override
    public NumericValue floor() {
        return new DecimalValue(this.value.setScale(0, 3));
    }

    @Override
    public NumericValue ceiling() {
        return new DecimalValue(this.value.setScale(0, 2));
    }

    @Override
    public NumericValue round() {
        switch (this.value.signum()) {
            case -1: {
                return new DecimalValue(this.value.setScale(0, 5));
            }
            case 0: {
                return this;
            }
            case 1: {
                return new DecimalValue(this.value.setScale(0, 4));
            }
        }
        return this;
    }

    @Override
    public NumericValue roundHalfToEven(int scale) {
        BigDecimal scaledValue;
        if (scale < 0 && !canSetScaleNegative) {
            try {
                AtomicValue val = this.convertPrimitive(BuiltInAtomicType.INTEGER, true, null).asAtomic();
                if (val instanceof Int64Value) {
                    return ((Int64Value)val).roundHalfToEven(scale);
                }
                return ((BigIntegerValue)val).roundHalfToEven(scale);
            }
            catch (XPathException xPathException) {
                throw new IllegalArgumentException("internal error in integer-decimal conversion");
            }
        }
        try {
            scaledValue = this.value.setScale(scale, 6);
        }
        catch (ArithmeticException e) {
            if (scale < 0) {
                canSetScaleNegative = false;
                return this.roundHalfToEven(scale);
            }
            throw e;
        }
        return new DecimalValue(scaledValue.stripTrailingZeros());
    }

    @Override
    public double signum() {
        return this.value.signum();
    }

    @Override
    public boolean isWholeNumber() {
        return this.value.scale() == 0 || this.value.compareTo(this.value.setScale(0, 1)) == 0;
    }

    @Override
    public NumericValue abs() {
        if (this.value.signum() > 0) {
            return this;
        }
        return new DecimalValue(this.value.negate());
    }

    @Override
    public int compareTo(Object other) {
        if (NumericValue.isInteger((NumericValue)other)) {
            try {
                return this.compareTo(((NumericValue)other).convertPrimitive(BuiltInAtomicType.DECIMAL, true, null).asAtomic());
            }
            catch (XPathException xPathException) {
                throw new AssertionError((Object)"Conversion of integer to decimal should never fail");
            }
        }
        if (other instanceof DecimalValue) {
            return this.value.compareTo(((DecimalValue)other).value);
        }
        if (other instanceof FloatValue) {
            try {
                return ((FloatValue)this.convertPrimitive(BuiltInAtomicType.FLOAT, true, null).asAtomic()).compareTo(other);
            }
            catch (XPathException xPathException) {
                throw new AssertionError((Object)"Conversion of decimal to float should never fail");
            }
        }
        return super.compareTo(other);
    }

    @Override
    public int compareTo(long other) {
        if (other == 0L) {
            return this.value.signum();
        }
        return this.value.compareTo(BigDecimal.valueOf(other));
    }

    @Override
    public Comparable getSchemaComparable() {
        return new DecimalComparable(this);
    }

    @Override
    public boolean isIdentical(Value v) {
        return v instanceof DecimalValue && this.equals(v);
    }

    protected static class DecimalComparable
    implements Comparable {
        protected DecimalValue value;

        public DecimalComparable(DecimalValue value) {
            this.value = value;
        }

        public BigDecimal asBigDecimal() {
            return this.value.getDecimalValue();
        }

        public int compareTo(Object o) {
            if (o instanceof DecimalComparable) {
                return this.asBigDecimal().compareTo(((DecimalComparable)o).asBigDecimal());
            }
            if (o instanceof Int64Value.Int64Comparable) {
                return this.asBigDecimal().compareTo(BigDecimal.valueOf(((Int64Value.Int64Comparable)o).asLong()));
            }
            if (o instanceof BigIntegerValue.BigIntegerComparable) {
                return this.value.compareTo(new BigDecimal(((BigIntegerValue.BigIntegerComparable)o).asBigInteger()));
            }
            return Integer.MIN_VALUE;
        }

        public boolean equals(Object o) {
            return this.compareTo(o) == 0;
        }

        public int hashCode() {
            if (this.value.isWholeNumber()) {
                try {
                    return this.value.convertPrimitive(BuiltInAtomicType.INTEGER, true, null).asAtomic().getSchemaComparable().hashCode();
                }
                catch (ValidationException validationException) {
                    return 12345678;
                }
            }
            return this.value.hashCode();
        }
    }
}

