/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xqj;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.Properties;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.transform.sax.SAXResult;
import javax.xml.xquery.XQConnection;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQItem;
import javax.xml.xquery.XQItemType;
import javax.xml.xquery.XQResultSequence;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.evpull.BracketedDocumentIterator;
import net.sf.saxon.evpull.Decomposer;
import net.sf.saxon.evpull.EventIterator;
import net.sf.saxon.evpull.EventIteratorOverSequence;
import net.sf.saxon.evpull.EventToStaxBridge;
import net.sf.saxon.expr.TailIterator;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.query.QueryResult;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Value;
import net.sf.saxon.xqj.Closable;
import net.sf.saxon.xqj.SaxonXQDataFactory;
import net.sf.saxon.xqj.SaxonXQItem;
import net.sf.saxon.xqj.SaxonXQItemAccessor;
import net.sf.saxon.xqj.SaxonXQPreparedExpression;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

public class SaxonXQSequence
extends Closable
implements XQResultSequence,
SaxonXQItemAccessor {
    private Value value;
    private int position;
    private SaxonXQPreparedExpression expression;
    private SaxonXQDataFactory factory;

    SaxonXQSequence(Value value, SaxonXQDataFactory factory) {
        this.value = value;
        this.factory = factory;
        this.setClosableContainer(factory);
    }

    SaxonXQSequence(Value value, SaxonXQPreparedExpression expression) {
        this.value = value;
        this.expression = expression;
        this.factory = expression.getConnection();
        this.setClosableContainer(expression);
    }

    Value getValue() {
        return this.value;
    }

    Configuration getConfiguration() {
        return this.factory.getConfiguration();
    }

    @Override
    public boolean absolute(int itempos) throws XQException {
        block8: {
            block9: {
                block6: {
                    block7: {
                        this.checkNotClosed();
                        try {
                            if (itempos <= 0) break block6;
                            if (itempos > this.value.getLength()) break block7;
                            this.position = itempos;
                            return true;
                        }
                        catch (XPathException e) {
                            throw this.newXQException(e);
                        }
                    }
                    this.position = -1;
                    return false;
                }
                if (itempos >= 0) break block8;
                if (-itempos > this.value.getLength()) break block9;
                this.position = this.value.getLength() + itempos + 1;
                return true;
            }
            this.position = 0;
            return false;
        }
        this.position = 0;
        return false;
    }

    @Override
    public void afterLast() throws XQException {
        this.checkNotClosed();
        this.position = -1;
    }

    @Override
    public void beforeFirst() throws XQException {
        this.checkNotClosed();
        this.position = 0;
    }

    @Override
    public int count() throws XQException {
        this.checkNotClosed();
        try {
            return this.value.getLength();
        }
        catch (XPathException e) {
            throw this.newXQException(e);
        }
    }

    @Override
    public boolean first() throws XQException {
        block3: {
            this.checkNotClosed();
            try {
                if (this.value.getLength() != 0) break block3;
                this.position = 0;
                return false;
            }
            catch (XPathException e) {
                throw this.newXQException(e);
            }
        }
        this.position = 1;
        return true;
    }

    @Override
    public XQItem getItem() throws XQException {
        this.checkNotClosed();
        try {
            SaxonXQItem item = new SaxonXQItem(this.value.itemAt(this.position - 1), this.factory);
            item.setClosableContainer(this);
            return item;
        }
        catch (XPathException e) {
            throw this.newXQException(e);
        }
    }

    @Override
    public Item getSaxonItem() throws XQException {
        try {
            return this.value.itemAt(this.position - 1);
        }
        catch (XPathException e) {
            throw this.newXQException(e);
        }
    }

    @Override
    public int getPosition() throws XQException {
        this.checkNotClosed();
        try {
            if (this.position >= 0) {
                return this.position;
            }
            return this.value.getLength() + 1;
        }
        catch (XPathException e) {
            throw this.newXQException(e);
        }
    }

    @Override
    public XMLStreamReader getSequenceAsStream() throws XQException {
        this.checkNotClosed();
        EventIterator ei = new EventIteratorOverSequence(this.iterateRemainder());
        ei = new BracketedDocumentIterator(ei);
        Configuration config = this.getConfiguration();
        PipelineConfiguration pipe = config.makePipelineConfiguration();
        pipe.setHostLanguage(51);
        ei = new Decomposer(ei, pipe);
        return new EventToStaxBridge(ei, pipe);
    }

    @Override
    public String getSequenceAsString(Properties props) throws XQException {
        this.checkNotClosed();
        StringWriter sw = new StringWriter();
        this.writeSequence(sw, props);
        return sw.toString();
    }

    @Override
    public boolean isAfterLast() throws XQException {
        this.checkNotClosed();
        return this.position < 0;
    }

    @Override
    public boolean isBeforeFirst() throws XQException {
        this.checkNotClosed();
        try {
            return this.position == 0 && this.value.getLength() != 0;
        }
        catch (XPathException e) {
            throw this.newXQException(e);
        }
    }

    @Override
    public boolean isFirst() throws XQException {
        this.checkNotClosed();
        return this.position == 1;
    }

    @Override
    public boolean isLast() throws XQException {
        this.checkNotClosed();
        try {
            return this.position == this.value.getLength();
        }
        catch (XPathException e) {
            throw this.newXQException(e);
        }
    }

    @Override
    public boolean isOnItem() throws XQException {
        this.checkNotClosed();
        return this.position >= 1;
    }

    @Override
    public boolean isScrollable() throws XQException {
        this.checkNotClosed();
        return true;
    }

    @Override
    public boolean last() throws XQException {
        int n;
        block3: {
            this.checkNotClosed();
            try {
                n = this.value.getLength();
                if (n != 0) break block3;
                this.position = -1;
                return false;
            }
            catch (XPathException e) {
                throw this.newXQException(e);
            }
        }
        this.position = n;
        return true;
    }

    @Override
    public boolean next() throws XQException {
        block3: {
            this.checkNotClosed();
            try {
                if (this.position != this.value.getLength()) break block3;
                this.position = -1;
                return false;
            }
            catch (XPathException e) {
                throw this.newXQException(e);
            }
        }
        ++this.position;
        return true;
    }

    @Override
    public boolean previous() throws XQException {
        this.checkNotClosed();
        if (this.position == -1) {
            return this.last();
        }
        --this.position;
        return this.position != 0;
    }

    @Override
    public boolean relative(int itempos) throws XQException {
        block5: {
            this.checkNotClosed();
            try {
                if (this.position == -1) {
                    this.position = this.value.getLength() + 1;
                }
                this.position += itempos;
                if (this.position > 0) break block5;
                this.position = 0;
                return false;
            }
            catch (XPathException e) {
                throw this.newXQException(e);
            }
        }
        if (this.position > this.value.getLength()) {
            this.position = -1;
            return false;
        }
        return true;
    }

    @Override
    public void writeSequence(OutputStream os, Properties props) throws XQException {
        this.checkNotClosed();
        this.checkNotNull(os);
        if (props == null) {
            props = new Properties();
        }
        props = SaxonXQSequence.setDefaultProperties(props);
        try {
            QueryResult.serializeSequence(this.iterateRemainder(), this.getConfiguration(), os, props);
            this.position = -1;
        }
        catch (XPathException e) {
            throw this.newXQException(e);
        }
    }

    @Override
    public void writeSequence(Writer ow, Properties props) throws XQException {
        this.checkNotClosed();
        this.checkNotNull(ow);
        if (props == null) {
            props = new Properties();
        }
        props = SaxonXQSequence.setDefaultProperties(props);
        try {
            PrintWriter pw = ow instanceof PrintWriter ? (PrintWriter)ow : new PrintWriter(ow);
            QueryResult.serializeSequence(this.iterateRemainder(), this.getConfiguration(), pw, props);
            this.position = -1;
        }
        catch (XPathException e) {
            throw this.newXQException(e);
        }
    }

    @Override
    public void writeSequenceToResult(Result result) throws XQException {
        this.checkNotClosed();
        Properties props = SaxonXQSequence.setDefaultProperties(null);
        try {
            QueryResult.serializeSequence(this.iterateRemainder(), this.getConfiguration(), result, props);
        }
        catch (XPathException e) {
            throw this.newXQException(e);
        }
    }

    @Override
    public void writeSequenceToSAX(ContentHandler saxHandler) throws XQException {
        this.checkNotClosed();
        this.writeSequenceToResult(new SAXResult(saxHandler));
    }

    @Override
    public String getAtomicValue() throws XQException {
        return this.getCurrentItem().getAtomicValue();
    }

    @Override
    public boolean getBoolean() throws XQException {
        return this.getCurrentItem().getBoolean();
    }

    @Override
    public byte getByte() throws XQException {
        return this.getCurrentItem().getByte();
    }

    @Override
    public double getDouble() throws XQException {
        return this.getCurrentItem().getDouble();
    }

    @Override
    public float getFloat() throws XQException {
        return this.getCurrentItem().getFloat();
    }

    @Override
    public int getInt() throws XQException {
        return this.getCurrentItem().getInt();
    }

    @Override
    public XMLStreamReader getItemAsStream() throws XQException {
        return this.getCurrentItem().getItemAsStream();
    }

    @Override
    public String getItemAsString(Properties props) throws XQException {
        return this.getCurrentItem().getItemAsString(props);
    }

    @Override
    public XQItemType getItemType() throws XQException {
        return this.getCurrentItem().getItemType();
    }

    @Override
    public long getLong() throws XQException {
        return this.getCurrentItem().getLong();
    }

    @Override
    public Node getNode() throws XQException {
        return this.getCurrentItem().getNode();
    }

    @Override
    public URI getNodeUri() throws XQException {
        return this.getCurrentItem().getNodeUri();
    }

    @Override
    public Object getObject() throws XQException {
        return this.getCurrentItem().getObject();
    }

    @Override
    public short getShort() throws XQException {
        return this.getCurrentItem().getShort();
    }

    @Override
    public boolean instanceOf(XQItemType type) throws XQException {
        return this.getCurrentItem().instanceOf(type);
    }

    @Override
    public void writeItem(OutputStream os, Properties props) throws XQException {
        this.getCurrentItem().writeItem(os, props);
    }

    @Override
    public void writeItem(Writer ow, Properties props) throws XQException {
        this.getCurrentItem().writeItem(ow, props);
    }

    @Override
    public void writeItemToResult(Result result) throws XQException {
        this.getCurrentItem().writeItemToResult(result);
    }

    @Override
    public void writeItemToSAX(ContentHandler saxHandler) throws XQException {
        this.getCurrentItem().writeItemToSAX(saxHandler);
    }

    private SaxonXQItem getCurrentItem() throws XQException {
        this.checkNotClosed();
        if (this.position == 0) {
            throw new XQException("Sequence is positioned before first item");
        }
        if (this.position < 0) {
            throw new XQException("Sequence is positioned after last item");
        }
        try {
            SaxonXQItem item = new SaxonXQItem(this.value.itemAt(this.position - 1), this.factory);
            item.setClosableContainer(this);
            return item;
        }
        catch (XPathException e) {
            throw this.newXQException(e);
        }
    }

    @Override
    public XQConnection getConnection() throws XQException {
        this.checkNotClosed();
        if (this.expression == null) {
            throw new IllegalStateException("Connection not available");
        }
        return this.expression.getConnection();
    }

    private SequenceIterator iterateRemainder() throws XQException {
        try {
            if (this.position == 0) {
                return this.value.iterate();
            }
            if (this.position < 0) {
                return EmptyIterator.getInstance();
            }
            return TailIterator.make(this.value.iterate(), this.position);
        }
        catch (XPathException e) {
            throw this.newXQException(e);
        }
    }

    private void checkNotNull(Object arg) throws XQException {
        if (arg == null) {
            throw new XQException("Argument is null");
        }
    }

    private XQException newXQException(Exception err) {
        XQException xqe = new XQException(err.getMessage());
        xqe.initCause(err);
        return xqe;
    }

    static Properties setDefaultProperties(Properties props) {
        Properties newProps = props == null ? new Properties() : new Properties(props);
        boolean changed = false;
        if (newProps.getProperty("method") == null) {
            newProps.setProperty("method", "xml");
            changed = true;
        }
        if (newProps.getProperty("indent") == null) {
            newProps.setProperty("indent", "yes");
            changed = true;
        }
        if (newProps.getProperty("omit-xml-declaration") == null) {
            newProps.setProperty("omit-xml-declaration", "yes");
            changed = true;
        }
        return changed || props == null ? newProps : props;
    }
}

