/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.tycho.dependency;

import java.io.File;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.tycho.core.ArtifactDependencyVisitor;
import org.eclipse.tycho.core.PluginDescription;
import org.eclipse.tycho.core.TychoProject;

public class CopyDependenciesMojo
extends AbstractMojo {
    private MavenSession session;
    private MavenProject project;
    private File outputDir;
    private Map<String, TychoProject> projectTypes;

    public void execute() throws MojoExecutionException, MojoFailureException {
        TychoProject tychoProject = this.projectTypes.get(this.project.getPackaging());
        if (tychoProject == null) {
            throw new MojoExecutionException("This only applies to Tycho projects");
        }
        if (!this.outputDir.exists()) {
            this.outputDir.mkdirs();
        }
        final StringBuilder errorBuilder = new StringBuilder();
        tychoProject.getDependencyWalker(this.project).walk(new ArtifactDependencyVisitor(){

            public void visitPlugin(PluginDescription pluginRef) {
                try {
                    File location = pluginRef.getLocation();
                    if (location.isFile()) {
                        FileUtils.copyFileToDirectory((File)pluginRef.getLocation(), (File)CopyDependenciesMojo.this.outputDir);
                    } else if (location.isDirectory()) {
                        if (pluginRef.getMavenProject() != null) {
                            CopyDependenciesMojo.this.getLog().warn((CharSequence)("Reactor projects not yet supported: " + pluginRef.getMavenProject()));
                        } else {
                            CopyDependenciesMojo.this.getLog().warn((CharSequence)("Directory-shaped bundles not yet supported: " + pluginRef.getLocation()));
                        }
                    }
                }
                catch (Exception ex) {
                    errorBuilder.append("Couldn't copy " + pluginRef.getLocation() + " to " + CopyDependenciesMojo.this.outputDir);
                    errorBuilder.append("\n");
                }
            }
        });
        if (errorBuilder.length() > 0) {
            throw new MojoFailureException(errorBuilder.toString());
        }
    }
}

