/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.common.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;

public class FileLocator {
    private static final String absolutePath = "abs://";
    private static final String pct20 = "%20";
    private static final int pct20len = 3;
    static /* synthetic */ Class class$com$arjuna$common$util$FileLocator;

    public static String locateFile(String findFile) throws FileNotFoundException {
        if (findFile == null) {
            throw new FileNotFoundException("locateFile: null file name");
        }
        if (findFile.startsWith(absolutePath)) {
            return findFile.substring(absolutePath.length());
        }
        String fullPathName = FileLocator.locateByProperty(findFile);
        if (fullPathName != null) {
            return fullPathName;
        }
        URL url = FileLocator.locateByResource(findFile);
        if (url != null) {
            fullPathName = url.getFile();
            int pos = 0;
            int len = fullPathName.length();
            int start = 0;
            StringBuffer decodedPathName = new StringBuffer();
            while ((pos = fullPathName.indexOf(pct20, start)) != -1) {
                decodedPathName.append(fullPathName.substring(start, pos));
                decodedPathName.append(' ');
                start = pos + 3;
            }
            if (start < len) {
                decodedPathName.append(fullPathName.substring(start, len));
            }
            fullPathName = decodedPathName.toString();
            if (FileLocator.platformIsWindows()) {
                fullPathName = fullPathName.substring(1, fullPathName.length());
            }
            return fullPathName;
        }
        throw new FileNotFoundException("locateFile: file not found: " + findFile);
    }

    public static URL locateURL(String findFile) throws FileNotFoundException {
        if (findFile == null) {
            throw new FileNotFoundException("locateURL: null file name");
        }
        try {
            if (findFile.startsWith(absolutePath)) {
                return new URL("file:/" + findFile.substring(absolutePath.length()));
            }
            String fullPathName = FileLocator.locateByProperty(findFile);
            if (fullPathName != null) {
                URL url = FileLocator.platformIsWindows() ? new URL("file:/" + fullPathName) : new URL("file:" + fullPathName);
                return url;
            }
        }
        catch (MalformedURLException e) {
            System.err.println("locateURL: URL creation problem");
            throw new FileNotFoundException("locateURL: URL creation problem");
        }
        URL url = FileLocator.locateByResource(findFile);
        if (url != null) {
            return url;
        }
        throw new FileNotFoundException("locateURL: file not found: " + findFile);
    }

    private static synchronized String locateByProperty(String findFile) {
        String fullPathName = null;
        String dir = null;
        File f = null;
        if (findFile == null) {
            return null;
        }
        try {
            dir = System.getProperty("user.dir");
            if (dir != null) {
                fullPathName = dir + File.separatorChar + findFile;
                f = new File(fullPathName);
            }
            if (f != null && f.exists()) {
                return fullPathName;
            }
            dir = System.getProperty("user.home");
            if (dir != null) {
                fullPathName = dir + File.separatorChar + findFile;
                f = new File(fullPathName);
            }
            if (f != null && f.exists()) {
                return fullPathName;
            }
            dir = System.getProperty("java.home");
            if (dir != null) {
                fullPathName = dir + File.separatorChar + findFile;
                f = new File(fullPathName);
            }
            if (f != null && f.exists()) {
                return fullPathName;
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    private static URL locateByResource(String findFile) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL url = loader.getResource(findFile);
        if (url == null) {
            url = (class$com$arjuna$common$util$FileLocator == null ? (class$com$arjuna$common$util$FileLocator = FileLocator.class$("com.arjuna.common.util.FileLocator")) : class$com$arjuna$common$util$FileLocator).getResource("/" + findFile);
        }
        return url;
    }

    private static boolean platformIsWindows() {
        return File.separatorChar == '\\';
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

