/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.unit.remote.driver.handler.http;

import org.jboss.unit.driver.DriverCommand;
import org.jboss.unit.remote.driver.ProtocolHandler;
import org.jboss.unit.remote.driver.RemoteDriverCommandContext;
import org.jboss.unit.remote.driver.RemoteDriverResponseContext;
import org.jboss.unit.remote.driver.TestConversation;
import org.jboss.unit.remote.driver.handler.http.HTTPConversation;
import org.jboss.unit.remote.driver.handler.http.command.DoGetCommand;
import org.jboss.unit.remote.driver.handler.http.command.DoPostCommand;
import org.jboss.unit.remote.driver.handler.http.command.HTTPDriverCommand;
import org.jboss.unit.remote.driver.handler.http.response.HTTPDriverResponse;
import org.jboss.unit.remote.driver.handler.http.response.InvokeGetResponse;
import org.jboss.unit.remote.driver.handler.http.response.InvokeMethodResponse;
import org.jboss.unit.remote.driver.handler.http.response.InvokePostResponse;
import org.jboss.unit.remote.http.HttpRequest;

public class HTTPHandler
implements ProtocolHandler {
    private ProtocolHandler nextHandler;

    public ProtocolHandler getNextHandler() {
        return this.nextHandler;
    }

    public void setNextHandler(ProtocolHandler nextHandler) {
        this.nextHandler = nextHandler;
    }

    public RemoteDriverCommandContext handleResponse(TestConversation testConversation, RemoteDriverResponseContext responseContext) {
        HTTPDriverResponse resp;
        if (responseContext.getResponse() instanceof HTTPDriverResponse && (resp = (HTTPDriverResponse)responseContext.getResponse()) instanceof InvokeMethodResponse) {
            if (resp instanceof InvokeGetResponse) {
                InvokeGetResponse igr = (InvokeGetResponse)resp;
                return new RemoteDriverCommandContext(responseContext, (DriverCommand)new DoGetCommand(igr.getURI(), igr.getHeaders()));
            }
            InvokePostResponse ipr = (InvokePostResponse)resp;
            HttpRequest.Body dpcb = ipr.getBody();
            return new RemoteDriverCommandContext(responseContext, (DriverCommand)new DoPostCommand(ipr.getURI(), ipr.getContentType(), dpcb));
        }
        if (this.nextHandler != null) {
            return this.nextHandler.handleResponse(testConversation, responseContext);
        }
        return null;
    }

    public RemoteDriverResponseContext handleCommand(TestConversation conversation, RemoteDriverCommandContext commandContext) throws Exception {
        if (commandContext.getCommand() instanceof HTTPDriverCommand) {
            HTTPConversation httpConversation = (HTTPConversation)conversation.getAttribute("http.conversation");
            if (httpConversation == null) {
                httpConversation = new HTTPConversation(conversation);
                conversation.setAttribute("http.conversation", httpConversation);
            }
            return httpConversation.invoke(commandContext);
        }
        if (this.nextHandler != null) {
            return this.nextHandler.handleCommand(conversation, commandContext);
        }
        return null;
    }
}

