/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.unit.remote.driver.handler.http;

import org.jboss.unit.remote.http.HttpRequest;
import org.jboss.unit.remote.driver.RemoteDriverResponseContext;
import org.jboss.unit.remote.driver.RemoteDriverCommandContext;
import org.jboss.unit.remote.driver.ProtocolHandler;
import org.jboss.unit.remote.driver.TestConversation;
import org.jboss.unit.remote.driver.handler.http.response.InvokePostResponse;
import org.jboss.unit.remote.driver.handler.http.response.InvokeGetResponse;
import org.jboss.unit.remote.driver.handler.http.response.HTTPDriverResponse;
import org.jboss.unit.remote.driver.handler.http.response.InvokeMethodResponse;
import org.jboss.unit.remote.driver.handler.http.command.DoPostCommand;
import org.jboss.unit.remote.driver.handler.http.command.DoGetCommand;
import org.jboss.unit.remote.driver.handler.http.command.HTTPDriverCommand;
import org.jboss.unit.remote.driver.webpage.WebPageDriverResponse;
import org.jboss.unit.remote.driver.webpage.GetPageResponse;
import org.jboss.unit.remote.driver.webpage.GetPageCommand;
import org.jboss.unit.remote.driver.webpage.ClickLinkResponse;
import org.jboss.unit.remote.driver.webpage.ClickLinkCommand;
import org.jboss.unit.remote.driver.webpage.WebPageDriverCommand;
import org.jboss.unit.remote.driver.webpage.WebPageConversation;

/**
 * @author <a href="mailto:julien@jboss.org">Julien Viet</a>
 * @version $Revision: 1.1 $
 */
public class HTTPHandler implements ProtocolHandler
{

   /** . */
   private ProtocolHandler nextHandler;

   public ProtocolHandler getNextHandler()
   {
      return nextHandler;
   }

   public void setNextHandler(ProtocolHandler nextHandler)
   {
      this.nextHandler = nextHandler;
   }

   public RemoteDriverCommandContext handleResponse(TestConversation testConversation, RemoteDriverResponseContext responseContext)
   {
      if (responseContext.getResponse() instanceof HTTPDriverResponse)
      {
         HTTPDriverResponse resp = (HTTPDriverResponse)responseContext.getResponse();
         if (resp instanceof InvokeMethodResponse)
         {
            if (resp instanceof InvokeGetResponse)
            {
               InvokeGetResponse igr = (InvokeGetResponse)resp;
               return new RemoteDriverCommandContext(responseContext, new DoGetCommand(igr.getURI(), igr.getHeaders()));
            }
            else
            {
               InvokePostResponse ipr = (InvokePostResponse)resp;
               HttpRequest.Body dpcb = ipr.getBody();
               return new RemoteDriverCommandContext(responseContext, new DoPostCommand(ipr.getURI(), ipr.getContentType(), dpcb));
            }
         }
      }
      else if(responseContext.getResponse() instanceof WebPageDriverResponse)
      {
         WebPageDriverResponse resp = (WebPageDriverResponse)responseContext.getResponse();
         if(resp instanceof GetPageResponse)
         {
            GetPageResponse pr = (GetPageResponse)resp;
            return new RemoteDriverCommandContext(responseContext, new GetPageCommand(pr.getUri()));
         }
         else if(resp instanceof ClickLinkResponse)
         {
            ClickLinkResponse pr = (ClickLinkResponse)resp;
            return new RemoteDriverCommandContext(responseContext, new ClickLinkCommand(pr.getUri(), pr.getLink()));
         }
      }

      //
      if (nextHandler != null)
      {
         return nextHandler.handleResponse(testConversation, responseContext);
      }

      //
      return null;
   }

   public RemoteDriverResponseContext handleCommand(TestConversation conversation, RemoteDriverCommandContext commandContext) throws Exception
   {
      if (commandContext.getCommand() instanceof HTTPDriverCommand)
      {
         HTTPConversation httpConversation = (HTTPConversation)conversation.getAttribute("http.conversation");

         //
         if (httpConversation == null)
         {
            httpConversation = new HTTPConversation(conversation);
            conversation.setAttribute("http.conversation", httpConversation);
         }

         //
         return httpConversation.invoke(commandContext);
      }
      else if(commandContext.getCommand() instanceof WebPageDriverCommand)
      {
         WebPageConversation webConversation = (WebPageConversation)conversation.getAttribute("web.conversation");
         
         if(webConversation == null)
         {
            webConversation = new WebPageConversation(conversation);
            conversation.setAttribute("web.conversation", webConversation);
         }
         
         return webConversation.invoke(commandContext);
      }

      //
      if (nextHandler != null)
      {
         return nextHandler.handleCommand(conversation, commandContext);
      }

      //
      return null;
   }
}
