/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.unit.remote.driver;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.jboss.unit.driver.DriverCommand;
import org.jboss.unit.driver.DriverResponse;
import org.jboss.unit.remote.driver.RemoteDriverResponseContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteDriverCommandContext {
    private RemoteDriverResponseContext responseContext;
    private final int requestCount;
    private DriverCommand command;
    private final Map<String, Serializable> payload;

    public RemoteDriverCommandContext(RemoteDriverResponseContext responseContext, DriverCommand command) {
        this.responseContext = responseContext;
        this.requestCount = responseContext.getCommandContext().requestCount + 1;
        this.command = command;
        this.payload = new HashMap<String, Serializable>(responseContext.getPayload());
    }

    public RemoteDriverCommandContext(DriverCommand command) {
        this.responseContext = null;
        this.requestCount = -1;
        this.command = command;
        this.payload = new HashMap<String, Serializable>();
    }

    public RemoteDriverCommandContext(RemoteDriverCommandContext commandContext, DriverCommand command) {
        HashMap<String, Serializable> payload = commandContext.responseContext != null ? new HashMap<String, Serializable>(commandContext.responseContext.getPayload()) : new HashMap();
        this.responseContext = commandContext.responseContext;
        this.requestCount = commandContext.requestCount + 1;
        this.command = command;
        this.payload = payload;
    }

    public RemoteDriverCommandContext(RemoteDriverCommandContext commandContext) {
        HashMap<String, Serializable> payload = commandContext.responseContext != null ? new HashMap<String, Serializable>(commandContext.responseContext.getPayload()) : new HashMap();
        this.responseContext = commandContext.responseContext;
        this.requestCount = commandContext.requestCount + 1;
        this.command = commandContext.command;
        this.payload = payload;
    }

    public Map<String, Serializable> getPayload() {
        return this.payload;
    }

    public int getRequestCount() {
        return this.requestCount;
    }

    public RemoteDriverResponseContext createResponseContext(DriverResponse response) {
        return new RemoteDriverResponseContext(this, response);
    }

    public RemoteDriverResponseContext getResponseContext() {
        return this.responseContext;
    }

    public DriverCommand getCommand() {
        return this.command;
    }
}

