/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.unit.remote.driver.handler.deployer;

import org.jboss.portal.test.framework.deployment.Deployer;
import org.jboss.portal.test.framework.server.Node;
import org.jboss.unit.driver.DriverResponse;
import org.jboss.unit.remote.driver.ProtocolHandler;
import org.jboss.unit.remote.driver.RemoteDriverCommandContext;
import org.jboss.unit.remote.driver.RemoteDriverResponseContext;
import org.jboss.unit.remote.driver.TestConversation;
import org.jboss.unit.remote.driver.handler.deployer.response.DeployResponse;
import org.jboss.unit.remote.driver.handler.deployer.response.UndeployResponse;

public class DeployerHandler
implements ProtocolHandler {
    private ProtocolHandler nextHandler;
    private Deployer deployer;
    private String archivePath;

    public ProtocolHandler getNextHandler() {
        return this.nextHandler;
    }

    public void setNextHandler(ProtocolHandler nextHandler) {
        this.nextHandler = nextHandler;
    }

    public Deployer getDeployer() {
        return this.deployer;
    }

    public void setDeployer(Deployer deployer) {
        this.deployer = deployer;
    }

    public String getArchivePath() {
        return this.archivePath;
    }

    public void setArchivePath(String archivePath) {
        this.archivePath = archivePath;
    }

    public RemoteDriverCommandContext handleResponse(TestConversation testConversation, RemoteDriverResponseContext responseContext) {
        DriverResponse response = responseContext.getResponse();
        if (response instanceof DeployResponse) {
            DeployResponse deploy = (DeployResponse)response;
            Node node = testConversation.getNode();
            try {
                this.deployer.deploy(this.archivePath, deploy.getId(), node);
            }
            catch (Exception e) {
                throw new Error(e);
            }
            return new RemoteDriverCommandContext(responseContext.getCommandContext());
        }
        if (response instanceof UndeployResponse) {
            UndeployResponse undeploy = (UndeployResponse)response;
            try {
                this.deployer.undeploy(this.archivePath, undeploy.getId());
            }
            catch (Exception e) {
                throw new Error(e);
            }
            return new RemoteDriverCommandContext(responseContext.getCommandContext());
        }
        if (this.nextHandler != null) {
            return this.nextHandler.handleResponse(testConversation, responseContext);
        }
        return null;
    }

    public RemoteDriverResponseContext handleCommand(TestConversation conversation, RemoteDriverCommandContext commandContext) throws Exception {
        if (this.nextHandler != null) {
            return this.nextHandler.handleCommand(conversation, commandContext);
        }
        return null;
    }
}

