/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.unit.remote.driver.webpage;

import org.jboss.portal.test.framework.server.Node;
import org.jboss.portal.test.framework.server.NodeId;
import org.jboss.unit.driver.DriverCommand;
import org.jboss.unit.driver.command.StartTestCommand;
import org.jboss.unit.remote.ResponseContext;
import org.jboss.unit.remote.driver.RemoteDriverCommandContext;
import org.jboss.unit.remote.driver.RemoteDriverResponseContext;
import org.jboss.unit.remote.driver.TestConversation;
import org.jboss.unit.remote.driver.webpage.SeleniumConfiguration;
import org.jboss.unit.remote.driver.webpage.WebPageDriverCommand;

public class WebPageConversation {
    private TestConversation currentConversation = null;

    public WebPageConversation(TestConversation currentConversation) {
        this.currentConversation = currentConversation;
    }

    public RemoteDriverResponseContext invoke(RemoteDriverCommandContext commandContext) throws Exception {
        RemoteDriverResponseContext responseContext = null;
        DriverCommand command = commandContext.getCommand();
        if (command instanceof WebPageDriverCommand) {
            ((WebPageDriverCommand)command).execute(this.getSeleniumConfig(commandContext), commandContext);
            this.pushContext(commandContext);
            responseContext = this.generateResponse(commandContext);
        }
        return responseContext;
    }

    private void pushContext(RemoteDriverCommandContext commandContext) {
        NodeId nodeId = NodeId.locate();
        Node node = this.currentConversation.getDriver().getNodeManager().getNode(nodeId);
        if (node == null) {
            throw new RuntimeException("Server Side Node could not be located. Make sure the Server Side Test Driver is deployed");
        }
        this.currentConversation.setNode(node);
        this.currentConversation.pushContext(commandContext);
    }

    private RemoteDriverResponseContext generateResponse(RemoteDriverCommandContext commandContext) {
        RemoteDriverResponseContext remoteResponseContext = null;
        ResponseContext responseContext = this.currentConversation.popContext();
        if (responseContext != null) {
            remoteResponseContext = commandContext.createResponseContext(responseContext.getResponse());
        }
        return remoteResponseContext;
    }

    private SeleniumConfiguration getSeleniumConfig(RemoteDriverCommandContext commandContext) {
        SeleniumConfiguration config = null;
        StartTestCommand startCommand = (StartTestCommand)commandContext.getResponseContext().getCommandContext().getCommand();
        String host = (String)startCommand.getParametrization().get("selenium-server-host");
        int port = Integer.parseInt((String)startCommand.getParametrization().get("selenium-server-port"));
        String browser = (String)startCommand.getParametrization().get("browser");
        config = new SeleniumConfiguration(host, port, browser);
        return config;
    }
}

