/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.unit.remote.driver.webpage;

import org.jboss.portal.test.framework.server.Node;
import org.jboss.unit.driver.DriverCommand;
import org.jboss.unit.driver.command.StartTestCommand;
import org.jboss.portal.test.framework.server.NodeId;
import org.jboss.unit.remote.driver.RemoteDriverCommandContext;
import org.jboss.unit.remote.driver.RemoteDriverResponseContext;
import org.jboss.unit.remote.driver.TestConversation;
import org.jboss.unit.remote.ResponseContext;

/**
 * @author <a href="mailto:sshah@redhat.com">Sohil Shah</a>
 *
 */
public class WebPageConversation
{
   private TestConversation currentConversation = null;
   
   /**
    * 
    * @param currentConversation
    */
   public WebPageConversation(TestConversation currentConversation)
   {
      this.currentConversation = currentConversation;
   }
   
   /**
    * 
    * @param commandContext
    * @return
    * @throws Exception
    */
   public RemoteDriverResponseContext invoke(RemoteDriverCommandContext commandContext) throws Exception
   {
      RemoteDriverResponseContext responseContext = null;
      
      DriverCommand command = commandContext.getCommand();
      if(command instanceof WebPageDriverCommand)
      {           
         ((WebPageDriverCommand)command).execute(this.getSeleniumConfig(commandContext), commandContext);
         
         //Push the data extracted from executing the command over to the Server Side Extension of the Test
         this.pushContext(commandContext);
                           
         //Generate a Response
         responseContext = this.generateResponse(commandContext);
      }
      
      return responseContext;
   }
   
   /**
    * 
    * @param commandContext
    */
   private void pushContext(RemoteDriverCommandContext commandContext)
   {
      NodeId nodeId = NodeId.locate();
      
      //Update to the next node
      Node node = this.currentConversation.getDriver().getNodeManager().getNode(nodeId);
      if (node == null)
      {
         throw new RuntimeException("Server Side Node could not be located. Make sure the Server Side Test Driver is deployed");
      }
      this.currentConversation.setNode(node);

      // Push context to the node
      this.currentConversation.pushContext(commandContext);
   }
   
   /**
    * 
    * @param commandContext
    */
   private RemoteDriverResponseContext generateResponse(RemoteDriverCommandContext commandContext)
   {
      RemoteDriverResponseContext remoteResponseContext = null;
            
      ResponseContext responseContext = this.currentConversation.popContext();
      
      if(responseContext != null)
      {
         remoteResponseContext = commandContext.createResponseContext(responseContext.getResponse());
      }
      
      return remoteResponseContext;
   }
   
   /**
    * 
    * @param commandContext
    * @return
    */
   private SeleniumConfiguration getSeleniumConfig(RemoteDriverCommandContext commandContext)
   {
      SeleniumConfiguration config = null;
      
      StartTestCommand startCommand = (StartTestCommand)commandContext.getResponseContext().getCommandContext().getCommand();
      
      String host = (String)startCommand.getParametrization().get("selenium-server-host");
      int port = Integer.parseInt((String)startCommand.getParametrization().get("selenium-server-port"));
      String browser = (String)startCommand.getParametrization().get("browser");
      
      config = new SeleniumConfiguration(host,port,browser);
      
      return config;
   }
}
