/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.unit.remote.driver;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.jboss.unit.driver.DriverResponse;
import org.jboss.unit.remote.driver.RemoteDriverCommandContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteDriverResponseContext {
    private final RemoteDriverCommandContext commandContext;
    private final DriverResponse response;
    private final Map<String, Serializable> payload;

    RemoteDriverResponseContext(RemoteDriverCommandContext commandContext, DriverResponse response) {
        this.commandContext = commandContext;
        this.response = response;
        this.payload = new HashMap<String, Serializable>();
    }

    public RemoteDriverCommandContext getCommandContext() {
        return this.commandContext;
    }

    public Map<String, Serializable> getPayload() {
        return this.payload;
    }

    public Object getPayload(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        return this.payload.get(name);
    }

    public void setPayload(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (value == null) {
            this.payload.remove(name);
        } else {
            this.payload.put(name, (Serializable)value);
        }
    }

    public void removePayload(String name) {
        this.setPayload(name, null);
    }

    public DriverResponse getResponse() {
        return this.response;
    }
}

