/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.unit.remote.driver.handler.http;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.jboss.logging.Logger;
import org.jboss.portal.test.framework.server.Node;
import org.jboss.unit.Failure;
import org.jboss.unit.driver.DriverCommand;
import org.jboss.unit.driver.DriverResponse;
import org.jboss.unit.driver.response.FailureResponse;
import org.jboss.unit.remote.ResponseContext;
import org.jboss.unit.remote.driver.RemoteDriverCommandContext;
import org.jboss.unit.remote.driver.RemoteDriverResponseContext;
import org.jboss.unit.remote.driver.TestConversation;
import org.jboss.unit.remote.driver.handler.http.command.DoGetCommand;
import org.jboss.unit.remote.driver.handler.http.command.DoMethodCommand;
import org.jboss.unit.remote.driver.handler.http.command.DoPostCommand;
import org.jboss.unit.remote.http.HttpHeader;
import org.jboss.unit.remote.http.HttpHeaders;
import org.jboss.unit.remote.http.HttpRequest;

public class HTTPConversation {
    private final Logger log = Logger.getLogger(this.getClass());
    private final HttpClient client;
    private final TestConversation conversation;

    public HTTPConversation(TestConversation conversation) {
        HttpClient client = new HttpClient((HttpConnectionManager)new SimpleHttpConnectionManager());
        client.getParams().setParameter("http.method.retry-handler", null);
        client.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials("test", "test"));
        this.conversation = conversation;
        this.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteDriverResponseContext invoke(RemoteDriverCommandContext commandContext) throws Exception {
        DriverCommand command = commandContext.getCommand();
        if (command instanceof DoMethodCommand) {
            DoMethodCommand method = (DoMethodCommand)command;
            URI uri = method.getURI();
            URL url = this.getURL(uri);
            if (command instanceof DoPostCommand) {
                DoPostCommand doPostCmd = (DoPostCommand)command;
                PostMethod post = null;
                try {
                    Object fb;
                    post = new PostMethod(url.toString());
                    post.setFollowRedirects(false);
                    HttpRequest.Body body = doPostCmd.getBody();
                    if (doPostCmd.getContentType() != null) {
                        post.addRequestHeader("Content-Type", doPostCmd.getContentType());
                    }
                    if (body instanceof HttpRequest.Raw) {
                        HttpRequest.Raw rb = (HttpRequest.Raw)body;
                        ByteArrayRequestEntity entity = new ByteArrayRequestEntity(rb.getBytes());
                        post.setRequestEntity((RequestEntity)entity);
                    } else if (body instanceof HttpRequest.Form) {
                        fb = (HttpRequest.Form)body;
                        ArrayList<NameValuePair> tmp = new ArrayList<NameValuePair>();
                        for (Object o : ((HttpRequest.Form)fb).getParameterNames()) {
                            String[] values;
                            String name = (String)o;
                            for (String value : values = ((HttpRequest.Form)fb).getParameterValues(name)) {
                                NameValuePair nvp = new NameValuePair(name, value);
                                tmp.add(nvp);
                            }
                        }
                        NameValuePair[] nvps = tmp.toArray(new NameValuePair[tmp.size()]);
                        post.setRequestBody(nvps);
                    }
                    this.executeHTTPMethod(commandContext, (HttpMethod)post);
                    fb = this.decodeHTTPResponse(commandContext, (HttpMethod)post);
                    return fb;
                }
                finally {
                    if (post != null) {
                        post.releaseConnection();
                    }
                }
            }
            DoGetCommand doGetCmd = (DoGetCommand)command;
            GetMethod get = null;
            try {
                get = new GetMethod(url.toString());
                HttpHeaders headers = doGetCmd.getHeaders();
                Iterator i = headers.headers();
                while (i.hasNext()) {
                    HttpHeader header = (HttpHeader)i.next();
                    Header _header = new Header(header.getName(), header.getValue());
                    get.addRequestHeader(_header);
                }
                get.setFollowRedirects(false);
                this.executeHTTPMethod(commandContext, (HttpMethod)get);
                RemoteDriverResponseContext remoteDriverResponseContext = this.decodeHTTPResponse(commandContext, (HttpMethod)get);
                return remoteDriverResponseContext;
            }
            finally {
                if (get != null) {
                    get.releaseConnection();
                }
            }
        }
        return commandContext.createResponseContext((DriverResponse)new FailureResponse(Failure.createErrorFailure((String)"Unexpected response")));
    }

    private URL getURL(URI uri) throws URISyntaxException, MalformedURLException {
        if (!uri.isAbsolute()) {
            Node node = this.conversation.getNode();
            int port = this.conversation.getDriver().getPort(node);
            uri = new URI("http://localhost:" + port).resolve(uri);
        }
        return uri.toURL();
    }

    private RemoteDriverResponseContext decodeHTTPResponse(RemoteDriverCommandContext commandContext, HttpMethod httpMethod) throws Exception {
        Header[] headers;
        DriverResponse response = null;
        ResponseContext ctx = this.conversation.popContext();
        if (ctx != null) {
            response = ctx.getResponse();
        }
        int status = httpMethod.getStatusCode();
        switch (status) {
            case 200: {
                if (response == null) {
                    response = new FailureResponse(Failure.createErrorFailure((String)("No result for test " + this.conversation.getTestId() + " in the response")));
                }
                this.log.info((Object)"# Received '200' code");
                break;
            }
            case 302: {
                if (response == null) {
                    Header locationHeader = httpMethod.getResponseHeader("location");
                    if (locationHeader != null) {
                        String redirectLocation = locationHeader.getValue();
                        this.log.info((Object)("# Received '302' code --> " + redirectLocation));
                        DoGetCommand cmd = new DoGetCommand(new URI(redirectLocation));
                        return this.invoke(new RemoteDriverCommandContext(commandContext.getResponseContext(), (DriverCommand)cmd));
                    }
                    response = new FailureResponse(Failure.createErrorFailure((String)"302 Code with corrupted data"));
                    break;
                }
                this.log.info((Object)"# Received Result object which overrides the 302");
                break;
            }
            case 500: {
                this.log.info((Object)"# Received '500' code");
                response = new FailureResponse(Failure.createErrorFailure((String)("Received '500' code at " + httpMethod.getURI())));
                break;
            }
            case 404: {
                this.log.info((Object)"# Received '404' code");
                response = new FailureResponse(Failure.createErrorFailure((String)("Received '404' code at " + httpMethod.getURI())));
                break;
            }
            default: {
                response = new FailureResponse(Failure.createErrorFailure((String)("Unexpected http code " + status + " at " + httpMethod.getURI())));
            }
        }
        RemoteDriverResponseContext responseCtx = commandContext.createResponseContext(response);
        byte[] body = httpMethod.getResponseBody();
        responseCtx.setPayload("http.response.body", body);
        HttpHeaders _headers = new HttpHeaders();
        for (Header header : headers = httpMethod.getResponseHeaders()) {
            HttpHeader _header = _headers.addHeader(header.getName());
            HeaderElement[] elts = header.getElements();
            if (elts == null) continue;
            for (HeaderElement elt : elts) {
                HttpHeader.Element _elt = _header.addElement(elt.getName(), elt.getValue());
                NameValuePair[] params = elt.getParameters();
                if (params == null) continue;
                for (NameValuePair param : params) {
                    _elt.addParam(param.getName(), param.getValue());
                }
            }
        }
        responseCtx.setPayload("http.response.headers", _headers);
        return responseCtx;
    }

    private int executeHTTPMethod(RemoteDriverCommandContext commandContext, HttpMethod method) throws Exception {
        int port = method.getURI().getPort();
        Node node = this.conversation.getDriver().getNode(port);
        if (node == null) {
            throw new IllegalArgumentException("Wrong port " + method.getURI().getPort() + " in URI " + method.getURI());
        }
        this.conversation.setNode(node);
        this.conversation.pushContext(commandContext);
        this.log.info((Object)("# Invoking test case over http " + method.getURI()));
        int status = this.client.executeMethod(method);
        method.getResponseBody();
        return status;
    }
}

