/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.unit.remote.web.deployment;

import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.Logger;
import org.jboss.kernel.plugins.deployment.xml.BeanXMLDeployer;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.kernel.spi.event.KernelEvent;
import org.jboss.kernel.spi.event.KernelEventListener;
import org.jboss.kernel.spi.registry.KernelRegistry;
import org.jboss.kernel.spi.registry.KernelRegistryEntry;
import org.jboss.unit.remote.web.deployment.ActualBootstrap;

public class WebBootstrap
implements ServletContextListener,
KernelEventListener {
    public static final String BEANS_RESOURCE_LOCATION_KEY = "jboss.portal.mc.beans_resource_location";
    public static final String BEANS_RESOURCE_TYPE_KEY = "jboss.portal.mc.beans_resource_type";
    public static final String DEFAULT_JBOSS_BEANS_RESOURCE_LOCATION = "/WEB-INF/jboss-beans.xml";
    public static final String CONTEXT_RESOURCE_TYPE = "context";
    public static final String CLASSLOADER_RESOURCE_TYPE = "classloader";
    private static final Logger log = Logger.getLogger(WebBootstrap.class);
    private ServletContext servletContext;
    private BeanXMLDeployer deployer;
    private KernelDeployment deployment;
    private boolean registered;
    private ActualBootstrap bootstrap;

    public void contextInitialized(ServletContextEvent event) {
        this.servletContext = event.getServletContext();
        try {
            this.bootstrap = new ActualBootstrap(this);
            this.bootstrap.run();
            log.info((Object)"Web kernel started");
        }
        catch (Exception e) {
            log.info((Object)"Web kernel boostrap failed", (Throwable)e);
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        log.info((Object)"Web kernel shutdown");
        if (this.deployment != null) {
            this.deployer.undeploy(this.deployment);
        }
        if (this.registered) {
            this.registered = false;
            try {
                KernelRegistry registry = this.bootstrap.getKernel().getRegistry();
                registry.unregisterListener((KernelEventListener)this, null, (Object)"ABC");
            }
            catch (Throwable throwable) {
                log.error((Object)"Cannot unregister kernel registry listener", throwable);
            }
        }
        this.servletContext = null;
        log.info((Object)"Web kernel stopped");
    }

    public void onEvent(KernelEvent event, Object object) {
        Object context = event.getContext();
        if (context instanceof String) {
            String key = (String)context;
            String type = event.getType();
            if ("KERNEL_REGISTRY_REGISTERED".equals(type)) {
                KernelRegistryEntry entry = this.bootstrap.getKernel().getRegistry().getEntry(context);
                Object target = entry.getTarget();
                this.servletContext.setAttribute(key, target);
            } else if ("KERNEL_REGISTRY_UNREGISTERED".equals(type)) {
                this.servletContext.removeAttribute(key);
            }
        }
    }

    void boostrap() throws Throwable {
        this.bootstrap.getKernel().getRegistry().registerListener((KernelEventListener)this, null, (Object)"ABC");
        this.registered = true;
        this.deployer = new BeanXMLDeployer(this.bootstrap.getKernel());
        URL url = this.getBeansURL();
        if (url != null) {
            log.debug((Object)("About to deploy beans url=" + url));
            this.deployment = this.deployer.deploy(url);
        } else {
            log.error((Object)"No valid beans URL was determined");
        }
    }

    protected URL getBeansURL() {
        String location = this.servletContext.getInitParameter(BEANS_RESOURCE_LOCATION_KEY);
        String type = this.servletContext.getInitParameter(BEANS_RESOURCE_TYPE_KEY);
        if (location == null) {
            location = DEFAULT_JBOSS_BEANS_RESOURCE_LOCATION;
            type = CONTEXT_RESOURCE_TYPE;
        } else if (type == null) {
            type = CONTEXT_RESOURCE_TYPE;
        }
        if (CONTEXT_RESOURCE_TYPE.equals(type)) {
            try {
                return this.servletContext.getResource(location);
            }
            catch (MalformedURLException e) {
                log.error((Object)("Cannot obtain beans definition file from servlet context with location=" + location), (Throwable)e);
                return null;
            }
        }
        if (CLASSLOADER_RESOURCE_TYPE.equals(type)) {
            URL resource = Thread.currentThread().getContextClassLoader().getResource(location);
            if (resource == null) {
                log.error((Object)("Cannot obtain bean definition file from thread context classloader with location=" + location));
            }
            return resource;
        }
        log.error((Object)("Cannot obtain bean definition file since the context type cannot be determined type=" + type));
        return null;
    }
}

