/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.unit.remote.driver.webpage;

import com.thoughtworks.selenium.DefaultSelenium;
import com.thoughtworks.selenium.Selenium;
import java.net.URI;
import org.jboss.unit.remote.driver.RemoteDriverCommandContext;
import org.jboss.unit.remote.driver.webpage.SeleniumConfiguration;
import org.jboss.unit.remote.driver.webpage.WebPageData;
import org.jboss.unit.remote.driver.webpage.WebPageDriverCommand;

public class ClickLinkCommand
extends WebPageDriverCommand {
    private String link = null;

    public ClickLinkCommand(URI uri, String link) {
        super(uri);
        this.link = link;
    }

    public String getLink() {
        return this.link;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(SeleniumConfiguration config, RemoteDriverCommandContext webPageCommandContext) {
        DefaultSelenium browser = null;
        try {
            browser = new DefaultSelenium(config.getHost(), config.getPort(), "*" + config.getBrowser(), this.uri.toString());
            browser.start();
            browser.open(this.uri.toString());
            browser.click(this.link);
            WebPageData pageData = this.extractPageData((Selenium)browser);
            webPageCommandContext.getPayload().put("pageData", pageData);
        }
        finally {
            if (browser != null) {
                browser.stop();
            }
        }
    }
}

