/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.unit.remote.driver.webpage;

import com.thoughtworks.selenium.Selenium;
import java.net.URI;
import org.jboss.unit.driver.DriverCommand;
import org.jboss.unit.remote.driver.RemoteDriverCommandContext;
import org.jboss.unit.remote.driver.webpage.SeleniumConfiguration;
import org.jboss.unit.remote.driver.webpage.WebPageData;

public abstract class WebPageDriverCommand
extends DriverCommand {
    protected URI uri = null;

    public WebPageDriverCommand(URI uri) {
        this.uri = uri;
    }

    public abstract void execute(SeleniumConfiguration var1, RemoteDriverCommandContext var2);

    public URI getUri() {
        return this.uri;
    }

    public WebPageData extractPageData(Selenium browser) {
        WebPageData pageData = new WebPageData();
        if (browser.isAlertPresent()) {
            pageData.setAlert(browser.getAlert());
        }
        pageData.setButtons(browser.getAllButtons());
        pageData.setLinks(browser.getAllLinks());
        pageData.setFields(browser.getAllFields());
        pageData.setWindowIds(browser.getAllWindowIds());
        pageData.setWindowNames(browser.getAllWindowNames());
        pageData.setWindowTitles(browser.getAllWindowTitles());
        pageData.setBodyText(browser.getBodyText());
        if (browser.isConfirmationPresent()) {
            pageData.setConfirmation(browser.getConfirmation());
        }
        pageData.setCookie(browser.getCookie());
        pageData.setHtmlSource(browser.getHtmlSource());
        pageData.setLocation(browser.getLocation());
        if (browser.isPromptPresent()) {
            pageData.setPrompt(browser.getPrompt());
        }
        return pageData;
    }
}

