/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.test.framework.server;

import java.io.Serializable;

public class NodeId
implements Serializable {
    public static final NodeId DEFAULT = new NodeId("default");
    public static final NodeId PORTS_01 = new NodeId("ports-01");
    public static final NodeId PORTS_02 = new NodeId("ports-02");
    private final String value;

    public NodeId(String value) {
        if (value == null) {
            throw new IllegalArgumentException("No null value accepted");
        }
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof NodeId) {
            NodeId that = (NodeId)o;
            return this.value.equals(that.value);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public static NodeId locate() throws IllegalStateException {
        String nodeName = System.getProperty("jboss.server.name");
        if (nodeName != null) {
            nodeName = System.getProperty("test.node.name");
        }
        if (nodeName == null) {
            nodeName = "default";
        }
        if ("default".equals(nodeName)) {
            return DEFAULT;
        }
        if ("ports-01".equals(nodeName)) {
            return PORTS_01;
        }
        if ("ports-02".equals(nodeName)) {
            return PORTS_02;
        }
        throw new IllegalStateException("Cannot determine node id " + nodeName);
    }
}

